/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.model;

import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import io.intino.sumus.model.Attribute;
import io.intino.sumus.model.Dashboard;
import io.intino.sumus.model.Report;
import io.intino.sumus.model.SumusGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractDashboard
extends Layer
implements Terminal {
    protected String id;
    protected String label;
    protected String locale;
    protected List<Dashboard.Group> groupList = new ArrayList<Dashboard.Group>();
    protected Dashboard.Realtime _realtime;
    protected Dashboard.Navigable _navigable;

    public AbstractDashboard(Node node) {
        super(node);
    }

    public String id() {
        return this.id;
    }

    public String label() {
        return this.label;
    }

    public String locale() {
        return this.locale;
    }

    public Dashboard id(String value) {
        this.id = value;
        return (Dashboard)this;
    }

    public Dashboard label(String value) {
        this.label = value;
        return (Dashboard)this;
    }

    public Dashboard locale(String value) {
        this.locale = value;
        return (Dashboard)this;
    }

    public List<Dashboard.Group> groupList() {
        return Collections.unmodifiableList(this.groupList);
    }

    public Dashboard.Group group(int index) {
        return this.groupList.get(index);
    }

    public List<Dashboard.Group> groupList(Predicate<Dashboard.Group> predicate) {
        return this.groupList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Dashboard.Group group(Predicate<Dashboard.Group> predicate) {
        return this.groupList().stream().filter(predicate).findFirst().orElse(null);
    }

    public Dashboard.Realtime asRealtime() {
        Layer as = this.a$(Dashboard.Realtime.class);
        return as != null ? (Dashboard.Realtime)as : (Dashboard.Realtime)this.core$().addAspect(Dashboard.Realtime.class);
    }

    public boolean isRealtime() {
        return this.core$().is(Dashboard.Realtime.class);
    }

    public void removeRealtime() {
        this.core$().removeAspect(Dashboard.Realtime.class);
    }

    public Dashboard.Navigable asNavigable() {
        return (Dashboard.Navigable)this.a$(Dashboard.Navigable.class);
    }

    public Dashboard.Navigable asNavigable(Attribute.Category navigation, List<String> nodes) {
        Dashboard.Navigable newElement = (Dashboard.Navigable)this.core$().addAspect(Dashboard.Navigable.class);
        newElement.core$().set((Layer)newElement, "navigation", Collections.singletonList(navigation));
        newElement.core$().set((Layer)newElement, "nodes", nodes);
        return newElement;
    }

    public boolean isNavigable() {
        return this.core$().is(Dashboard.Navigable.class);
    }

    public void removeNavigable() {
        this.core$().removeAspect(Dashboard.Navigable.class);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Dashboard.Group>(this.groupList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("id", new ArrayList<String>(Collections.singletonList(this.id)));
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        map.put("locale", new ArrayList<String>(Collections.singletonList(this.locale)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Dashboard$Group")) {
            this.groupList.add((Dashboard.Group)node.as(Dashboard.Group.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Dashboard$Group")) {
            this.groupList.remove(node.as(Dashboard.Group.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("id")) {
            this.id = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("label")) {
            this.label = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("locale")) {
            this.locale = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("id")) {
            this.id = (String)values.get(0);
        } else if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        } else if (name.equalsIgnoreCase("locale")) {
            this.locale = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Dashboard.Group group(String label, List<Report> reports) {
            Dashboard.Group newElement = (Dashboard.Group)AbstractDashboard.this.core$().graph().concept(Dashboard.Group.class).createNode(this.name, AbstractDashboard.this.core$()).as(Dashboard.Group.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "reports", reports);
            return newElement;
        }
    }

    public class Clear {
        public void group(Predicate<Dashboard.Group> filter) {
            new ArrayList<Dashboard.Group>(AbstractDashboard.this.groupList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public static abstract class AbstractNavigable
    extends Layer
    implements Terminal {
        protected Attribute.Category navigation;
        protected List<String> nodes = new ArrayList<String>();
        protected Dashboard _dashboard;

        public AbstractNavigable(Node node) {
            super(node);
        }

        public Attribute.Category navigation() {
            return this.navigation;
        }

        public List<String> nodes() {
            return this.nodes;
        }

        public String nodes(int index) {
            return this.nodes.get(index);
        }

        public List<String> nodes(Predicate<String> predicate) {
            return this.nodes().stream().filter(predicate).collect(Collectors.toList());
        }

        public String id() {
            return this._dashboard.id();
        }

        public String label() {
            return this._dashboard.label();
        }

        public String locale() {
            return this._dashboard.locale();
        }

        public Dashboard.Navigable navigation(Attribute.Category value) {
            this.navigation = value;
            return (Dashboard.Navigable)this;
        }

        public Dashboard.Navigable id(String value) {
            this._dashboard.id(value);
            return (Dashboard.Navigable)this;
        }

        public Dashboard.Navigable label(String value) {
            this._dashboard.label(value);
            return (Dashboard.Navigable)this;
        }

        public Dashboard.Navigable locale(String value) {
            this._dashboard.locale(value);
            return (Dashboard.Navigable)this;
        }

        public List<Dashboard.Group> groupList() {
            return this._dashboard.groupList();
        }

        public Dashboard.Group groupList(int index) {
            return this._dashboard.groupList().get(index);
        }

        public Dashboard asDashboard() {
            return (Dashboard)this.a$(Dashboard.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("navigation", this.navigation != null ? new ArrayList<Attribute.Category>(Collections.singletonList(this.navigation)) : Collections.emptyList());
            map.put("nodes", this.nodes);
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("navigation")) {
                this.navigation = (Attribute.Category)((Object)NodeLoader.load(values, Attribute.Category.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("nodes")) {
                this.nodes = StringLoader.load(values, (Layer)this);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("navigation")) {
                this.navigation = values.get(0) != null ? (Attribute.Category)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Attribute.Category.class) : null;
            } else if (name.equalsIgnoreCase("nodes")) {
                this.nodes = new ArrayList(values);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Dashboard) {
                this._dashboard = (Dashboard)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Dashboard.Group group(String label, List<Report> reports) {
                Dashboard.Group newElement = (Dashboard.Group)AbstractNavigable.this.core$().graph().concept(Dashboard.Group.class).createNode(this.name, AbstractNavigable.this.core$()).as(Dashboard.Group.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                newElement.core$().set((Layer)newElement, "reports", reports);
                return newElement;
            }
        }

        public class Clear {
            public void group(Predicate<Dashboard.Group> filter) {
                new ArrayList<Dashboard.Group>(AbstractNavigable.this.groupList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static abstract class AbstractRealtime
    extends Layer
    implements Terminal {
        protected Dashboard _dashboard;

        public AbstractRealtime(Node node) {
            super(node);
        }

        public String id() {
            return this._dashboard.id();
        }

        public String label() {
            return this._dashboard.label();
        }

        public String locale() {
            return this._dashboard.locale();
        }

        public Dashboard.Realtime id(String value) {
            this._dashboard.id(value);
            return (Dashboard.Realtime)this;
        }

        public Dashboard.Realtime label(String value) {
            this._dashboard.label(value);
            return (Dashboard.Realtime)this;
        }

        public Dashboard.Realtime locale(String value) {
            this._dashboard.locale(value);
            return (Dashboard.Realtime)this;
        }

        public List<Dashboard.Group> groupList() {
            return this._dashboard.groupList();
        }

        public Dashboard.Group groupList(int index) {
            return this._dashboard.groupList().get(index);
        }

        public Dashboard asDashboard() {
            return (Dashboard)this.a$(Dashboard.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Dashboard) {
                this._dashboard = (Dashboard)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Dashboard.Group group(String label, List<Report> reports) {
                Dashboard.Group newElement = (Dashboard.Group)AbstractRealtime.this.core$().graph().concept(Dashboard.Group.class).createNode(this.name, AbstractRealtime.this.core$()).as(Dashboard.Group.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                newElement.core$().set((Layer)newElement, "reports", reports);
                return newElement;
            }
        }

        public class Clear {
            public void group(Predicate<Dashboard.Group> filter) {
                new ArrayList<Dashboard.Group>(AbstractRealtime.this.groupList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static abstract class AbstractGroup
    extends Layer
    implements Terminal {
        protected String label;
        protected List<Report> reports = new ArrayList<Report>();

        public AbstractGroup(Node node) {
            super(node);
        }

        public String label() {
            return this.label;
        }

        public List<Report> reports() {
            return this.reports;
        }

        public Report reports(int index) {
            return this.reports.get(index);
        }

        public List<Report> reports(Predicate<Report> predicate) {
            return this.reports().stream().filter(predicate).collect(Collectors.toList());
        }

        public Dashboard.Group label(String value) {
            this.label = value;
            return (Dashboard.Group)this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            map.put("reports", this.reports);
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("reports")) {
                this.reports = NodeLoader.load(values, Report.class, (Layer)this);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            } else if (name.equalsIgnoreCase("reports")) {
                this.reports = values.stream().map(s -> (Report)this.graph().core$().load(((Layer)s).core$().id()).as(Report.class)).collect(Collectors.toList());
            }
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }
}

