/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.model;

import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.tags.Component;
import io.intino.magritte.framework.tags.Terminal;
import io.intino.sumus.model.Attribute;
import io.intino.sumus.model.Classifiable;
import io.intino.sumus.model.Cube;
import io.intino.sumus.model.Filter;
import io.intino.sumus.model.Node;
import io.intino.sumus.model.Range;
import io.intino.sumus.model.Slice;
import io.intino.sumus.model.SumusGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractCube
extends Layer
implements Component,
Terminal {
    protected List<Classifiable> dimensions = new ArrayList<Classifiable>();
    protected int level;
    protected List<Filter> filterList = new ArrayList<Filter>();

    public AbstractCube(io.intino.magritte.framework.Node node) {
        super(node);
    }

    public List<Classifiable> dimensions() {
        return this.dimensions;
    }

    public Classifiable dimensions(int index) {
        return this.dimensions.get(index);
    }

    public List<Classifiable> dimensions(Predicate<Classifiable> predicate) {
        return this.dimensions().stream().filter(predicate).collect(Collectors.toList());
    }

    public int level() {
        return this.level;
    }

    public Cube level(int value) {
        this.level = value;
        return (Cube)this;
    }

    public List<Filter> filterList() {
        return Collections.unmodifiableList(this.filterList);
    }

    public Filter filter(int index) {
        return this.filterList.get(index);
    }

    public List<Filter> filterList(Predicate<Filter> predicate) {
        return this.filterList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Filter filter(Predicate<Filter> predicate) {
        return this.filterList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<io.intino.magritte.framework.Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Filter>(this.filterList).forEach(c -> components.add(c.core$()));
        return new ArrayList<io.intino.magritte.framework.Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("dimensions", this.dimensions);
        map.put("level", new ArrayList<Integer>(Collections.singletonList(this.level)));
        return map;
    }

    protected void addNode$(io.intino.magritte.framework.Node node) {
        super.addNode$(node);
        if (node.is("Filter")) {
            this.filterList.add((Filter)node.as(Filter.class));
        }
    }

    protected void removeNode$(io.intino.magritte.framework.Node node) {
        super.removeNode$(node);
        if (node.is("Filter")) {
            this.filterList.remove(node.as(Filter.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("dimensions")) {
            this.dimensions = NodeLoader.load(values, Classifiable.class, (Layer)this);
        } else if (name.equalsIgnoreCase("level")) {
            this.level = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("dimensions")) {
            this.dimensions = values.stream().map(s -> (Classifiable)this.graph().core$().load(((Layer)s).core$().id()).as(Classifiable.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("level")) {
            this.level = (Integer)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Slice slice(Attribute.Category attribute, String value) {
            Slice newElement = (Slice)AbstractCube.this.core$().graph().concept(Slice.class).createNode(this.name, AbstractCube.this.core$()).as(Slice.class);
            newElement.core$().set((Layer)newElement, "attribute", Collections.singletonList(attribute));
            newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
            return newElement;
        }

        public Node node(Node.Type type) {
            Node newElement = (Node)AbstractCube.this.core$().graph().concept(Node.class).createNode(this.name, AbstractCube.this.core$()).as(Node.class);
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        public Range range(Attribute.Date attribute) {
            Range newElement = (Range)AbstractCube.this.core$().graph().concept(Range.class).createNode(this.name, AbstractCube.this.core$()).as(Range.class);
            newElement.core$().set((Layer)newElement, "attribute", Collections.singletonList(attribute));
            return newElement;
        }
    }
}

