/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.watcher;

import io.intino.alexandria.logger.Logger;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.reporting.Dashboard;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class LedgerWatcher {
    private final SumusBox box;
    private final Map<String, Instant> updatedLedgers = new ConcurrentHashMap<String, Instant>();
    private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
    private WatchService watcher;
    private Thread thread;
    private boolean isClosed;

    public LedgerWatcher(SumusBox box) {
        this.box = box;
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Set<String> updatedLedgers() {
        return new HashSet<String>(this.updatedLedgers.keySet());
    }

    public void updatedLedgers(List<String> ledgers) {
        ledgers.forEach(l -> this.updatedLedgers.putIfAbsent((String)l, Instant.now()));
    }

    public void remove(Collection<String> paths) {
        paths.forEach(this.updatedLedgers::remove);
    }

    public void start() throws IOException {
        if (!this.isClosed) {
            return;
        }
        this.createWatcher();
        this.watchFiles();
        this.isClosed = false;
    }

    public void stop() throws IOException {
        this.isClosed = true;
        if (this.watcher != null) {
            this.watcher.close();
        }
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    private void createWatcher() throws IOException {
        this.watcher = FileSystems.getDefault().newWatchService();
        this.keys.clear();
        for (Dashboard dashboard : this.box.dashboards()) {
            for (String ledger : this.ledgers(dashboard)) {
                this.watchDir(new File(dashboard.datamart(), ledger));
            }
        }
    }

    private void watchFiles() {
        this.thread = new Thread(this::listener, "Ledger watcher thread");
        this.thread.start();
    }

    private void listener() {
        block4: {
            try {
                while (!this.isClosed) {
                    WatchKey key = this.watcher.poll(5L, TimeUnit.MINUTES);
                    if (key == null) continue;
                    Path dir = this.keys.get(key);
                    HashSet<File> files = new HashSet<File>();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path name = (Path)event.context();
                        files.add(dir.resolve(name).toFile());
                    }
                    files.forEach(file -> this.updatedLedgers.put(file.getAbsolutePath(), Instant.now()));
                    key.reset();
                }
            }
            catch (Throwable e) {
                if (this.isClosed) break block4;
                Logger.error((String)"Ledger listener stopped unexpectedly", (Throwable)e);
            }
        }
    }

    private void watchDir(File file) throws IOException {
        if (!file.exists() || file.isFile()) {
            return;
        }
        Path path = file.toPath();
        WatchKey key = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        this.keys.put(key, path);
    }

    private Set<String> ledgers(Dashboard dashboard) {
        return dashboard.reports().stream().flatMap(r -> r.ledgers().stream()).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

