/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.util;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.sumus.box.serializers.SyntaxHelper;
import io.intino.sumus.model.RangeBoundary;
import io.intino.sumus.model.rules.Month;
import io.intino.sumus.reporting.ReactiveFunction;
import java.io.File;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.Year;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReactiveHelper {
    public static String serialize(List<RangeBoundary.BoundaryType> types) {
        return types.stream().map(ReactiveHelper::serialize).filter(Objects::nonNull).collect(Collectors.joining("\n"));
    }

    public static String serialize(RangeBoundary.BoundaryType type) {
        RangeBoundary base = type.asRangeBoundary();
        if (base.isDate()) {
            return ReactiveHelper.serialize(base.asDate());
        }
        if (base.isRelative()) {
            return ReactiveHelper.serialize(base.asRelative());
        }
        return null;
    }

    private static String serialize(RangeBoundary.Date date) {
        List<CallSite> args = List.of("" + date.day(), String.valueOf((Object)date.month()), String.valueOf((Object)date.year()));
        return ReactiveHelper.serialize(FunctionType.Date, SyntaxHelper.reactiveID(date), args);
    }

    private static String serialize(RangeBoundary.Relative relative) {
        List<CallSite> args = List.of("" + relative.amount(), String.valueOf((Object)relative.scale()));
        return ReactiveHelper.serialize(FunctionType.Relative, SyntaxHelper.reactiveID(relative), args);
    }

    private static String serialize(FunctionType type, String id, List<String> args) {
        return "%s\t%s\t%s".formatted(new Object[]{type, id, String.join((CharSequence)",", args)});
    }

    public static List<ReactiveFunction> deserialize(List<File> files) {
        return files.stream().flatMap(f -> ReactiveHelper.deserialize(f).stream()).toList();
    }

    public static List<ReactiveFunction> deserialize(File file) {
        List<ReactiveFunction> list;
        block8: {
            Stream<String> lines = Files.lines(file.toPath());
            try {
                list = lines.map(l -> l.split("\t")).map(ReactiveHelper::deserialize).filter(Objects::nonNull).toList();
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    Logger.warn((String)("Error deserializing reactive functions from " + file.getAbsolutePath()));
                    return Collections.emptyList();
                }
            }
            lines.close();
        }
        return list;
    }

    private static ReactiveFunction deserialize(final String[] tsv) {
        String[] args;
        if (tsv.length < 3) {
            return null;
        }
        FunctionType type = FunctionType.valueOf(tsv[0]);
        final Function<Timetag, String> function = ReactiveHelper.reactiveFunction(type, args = tsv[2].split(","));
        if (function == null) {
            return null;
        }
        return new ReactiveFunction(){

            @Override
            public String name() {
                return tsv[1];
            }

            @Override
            public String function(Timetag timetag) {
                return (String)function.apply(timetag);
            }
        };
    }

    private static Function<Timetag, String> reactiveFunction(FunctionType type, String[] args) {
        try {
            if (type == FunctionType.Date) {
                return ReactiveHelper.reactiveFunction(Integer.parseInt(args[0]), Month.valueOf(args[1]), RangeBoundary.Date.Year.valueOf(args[2]));
            }
            if (type == FunctionType.Relative) {
                return ReactiveHelper.reactiveFunction(Integer.parseInt(args[0]), RangeBoundary.Relative.Scale.valueOf(args[1]));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Function<Timetag, String> reactiveFunction(int day, Month month, RangeBoundary.Date.Year yearType) {
        return t -> {
            LocalDate tt = t.datetime().toLocalDate();
            LocalDate date = LocalDate.of(Year.now().getValue(), month.getValue(), day);
            switch (yearType) {
                case CurrentYear: {
                    date = date.withYear(tt.getYear());
                    break;
                }
                case NextYear: {
                    date = date.withYear(tt.getYear() + 1);
                    break;
                }
                case PreviousYear: {
                    date = date.withYear(tt.getYear() - 1);
                }
            }
            return String.valueOf(date);
        };
    }

    private static Function<Timetag, String> reactiveFunction(int amount, RangeBoundary.Relative.Scale scale) {
        return t -> {
            LocalDate date = t.datetime().toLocalDate();
            switch (scale) {
                case Day: {
                    date = date.plusDays(amount);
                    break;
                }
                case Month: {
                    date = date.plusMonths(amount);
                    break;
                }
                case Week: {
                    date = date.plusWeeks(amount);
                    break;
                }
                case Year: {
                    date = date.plusYears(amount);
                }
            }
            return String.valueOf(date);
        };
    }

    static enum FunctionType {
        Date,
        Relative;

    }
}

