/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.util;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.sumus.box.RealtimeBuilder;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.util.TimetagHelper;
import io.intino.sumus.reporting.Dashboard;

public class NodeRealtimeBuilder
implements RealtimeBuilder {
    private final SumusBox box;

    public NodeRealtimeBuilder(SumusBox box) {
        this.box = box;
    }

    @Override
    public String build(String dashboardName, String reportName, Timetag timetag, String nodeName) {
        Dashboard dashboard = this.box.dashboard(dashboardName);
        if (dashboard == null) {
            Logger.warn((String)("Dashboard " + dashboardName + " not found"));
            return "";
        }
        Dashboard.Report report = dashboard.report(reportName);
        if (report == null) {
            Logger.warn((String)("Report " + reportName + " not found"));
            return "";
        }
        if (!TimetagHelper.isValid(timetag)) {
            Logger.warn((String)("Invalid timetag " + String.valueOf(timetag)));
            return "";
        }
        return this.box.dashboardBuilder(dashboard).buildNodeContent(report, timetag, this.nodeOf(nodeName));
    }

    private String nodeOf(String name) {
        return "_All".equalsIgnoreCase(name) ? "" : name;
    }
}

