/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.util;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.office.XlsBuilder;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.filters.GroupFilter;
import io.intino.alexandria.ui.model.datasource.filters.RangeFilter;
import io.intino.alexandria.ui.model.dynamictable.Column;
import io.intino.alexandria.ui.model.dynamictable.Row;
import io.intino.alexandria.ui.model.dynamictable.Section;
import io.intino.sumus.box.I18n;
import io.intino.sumus.box.ui.datasources.CubeDatasource;
import io.intino.sumus.box.util.Formatters;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Slice;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import spark.utils.IOUtils;

public class DocumentGenerator {
    private final CubeDatasource source;
    private final String imageDefinition;
    private static final String HeaderAir = "\n\n\n\n\n";
    private static final String TitleDefinition = "#define text 1:1:*%s\n";
    private static final String TimetagDefinition = "#define text 2:1: %s\n";
    private static final int FilterRowOffset = 1;
    private static final String FilterNameDefinition = "#define text %d:4:$%s\n";
    private static final String FilterValueDefinition = "#define text %d:5: %s\n";
    private static final String Column = "#%s;";
    private static final String RowLabelDefinition = "#define column %d:20:Right:#,##0.00:%s\n";
    private static final String ColumnDefinition = "#define column %d:10:Right:#,##0.00:%s\n";

    public DocumentGenerator(CubeDatasource source, String logo) {
        this.source = source;
        this.imageDefinition = "#define image 0:0:1:5:" + Formatters.logo(logo) + "\n";
    }

    public static String logo() {
        return DocumentGenerator.logo("");
    }

    public static String logo(String prefix) {
        String string;
        block8: {
            InputStream stream = Formatters.class.getResourceAsStream("/logo.png.txt");
            try {
                string = prefix + new String(IOUtils.toByteArray((InputStream)stream));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.error((Throwable)e);
                    return null;
                }
            }
            stream.close();
        }
        return string;
    }

    public InputStream generate(Timetag timetag, String dimension, String drill, String condition, List<Filter> filters) {
        try {
            List<Section> sections = this.source.sections(timetag, dimension, drill, condition, filters);
            XlsBuilder builder = XlsBuilder.create();
            this.createSheet(builder, dimension, sections, timetag, condition, filters);
            File file = this.tempFile(".xls");
            if (file == null) {
                return null;
            }
            builder.save(file);
            return new FileInputStream(file);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private void createSheet(XlsBuilder builder, String dimension, List<Section> sections, Timetag timetag, String condition, List<Filter> filters) {
        try {
            builder.append(I18n.translate("Details", this.source.language()), this.csvOf(dimension, sections, timetag, condition, filters));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private File csvOf(String dimension, List<Section> sections, Timetag timetag, String condition, List<Filter> filters) throws IOException {
        File tempFile = this.tempFile("csv");
        if (tempFile == null) {
            return null;
        }
        List<Column> columns = this.columnsOf(sections);
        String csvContent = this.headerAir(condition, filters) + this.serializeCols(dimension, sections, columns) + "\n" + this.serializeRows(sections) + "\n" + this.imageDefinition + String.format(TitleDefinition, this.title()) + String.format(TimetagDefinition, this.timetag(timetag)) + this.serialize(condition, filters) + String.valueOf(this.columnsDefinition(columns));
        Files.write(tempFile.toPath(), csvContent.getBytes(), new OpenOption[0]);
        return tempFile;
    }

    private String headerAir(String condition, List<Filter> filters) {
        int count = 0;
        if (condition != null && !condition.isEmpty()) {
            ++count;
        }
        count += this.source.attachedValues().size();
        count = HeaderAir.length() + ((count += filters.size()) >= HeaderAir.length() ? count - HeaderAir.length() + 2 : 1);
        StringBuffer result = new StringBuffer();
        IntStream.range(0, count).forEach(i -> result.append("\n"));
        return result.toString();
    }

    private String title() {
        return "Cosmos " + I18n.translate(this.source.name(), this.source.language()).toLowerCase();
    }

    private String timetag(Timetag timetag) {
        return Formatters.excelDate(timetag, this.source.language());
    }

    private String serialize(String condition, List<Filter> filters) {
        StringBuilder result = new StringBuilder();
        int index = this.serializeAttached(result);
        index = this.serializeCondition(result, condition, index);
        this.serializeFilters(filters, result, index);
        return result.toString();
    }

    private int serializeAttached(StringBuilder result) {
        ArrayList<Map.Entry<Dimension, Slice>> entries = new ArrayList<Map.Entry<Dimension, Slice>>(this.source.attachedValues().entrySet());
        int index = 0;
        for (Map.Entry entry : entries) {
            result.append(String.format(FilterNameDefinition, index + 1, ((Dimension)entry.getKey()).name()));
            result.append(String.format(FilterValueDefinition, index + 1, ((Slice)entry.getValue()).name()));
            ++index;
        }
        return index;
    }

    private int serializeCondition(StringBuilder result, String condition, int index) {
        if (condition == null || condition.isEmpty()) {
            return index;
        }
        result.append(String.format(FilterNameDefinition, index + 1, I18n.translate("Condition", this.source.language())));
        result.append(String.format(FilterValueDefinition, index + 1, condition));
        return ++index;
    }

    private void serializeFilters(List<Filter> filters, StringBuilder result, int index) {
        for (Filter filter : filters) {
            result.append(String.format(FilterNameDefinition, index + 1, filter.grouping()));
            result.append(String.format(FilterValueDefinition, index + 1, this.serializeValuesOf(filter)));
            ++index;
        }
    }

    private String serializeValuesOf(Filter filter) {
        if (filter instanceof GroupFilter) {
            return String.join((CharSequence)", ", ((GroupFilter)filter).groups());
        }
        if (filter instanceof RangeFilter) {
            return String.valueOf(((RangeFilter)filter).from()) + " - " + String.valueOf(((RangeFilter)filter).to());
        }
        return "";
    }

    private List<Column> columnsOf(List<Section> sections) {
        return sections.isEmpty() ? Collections.emptyList() : this.columnsOf(sections.get(0));
    }

    private List<Column> columnsOf(Section section) {
        ArrayList<Column> result = new ArrayList<Column>(section.columns());
        section.sections().forEach(s -> result.addAll(this.columnsOf((Section)s)));
        return result;
    }

    private List<String> rowsOf(Section section, boolean addSectionLabel) {
        ArrayList<String> result = new ArrayList<String>();
        List<Section> sections = this.leafSections(section);
        if (sections.isEmpty()) {
            return Collections.emptyList();
        }
        for (int i = 0; i < sections.get(0).rows().size(); ++i) {
            result.add(this.rowOf(sections, addSectionLabel, i));
        }
        return result;
    }

    private String rowOf(List<Section> sections, boolean addSectionLabel, int index) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < sections.size(); ++i) {
            Section section = sections.get(i);
            Row row = (Row)section.rows().get(index);
            if (i == 0) {
                result.append(row.label()).append(";");
                if (addSectionLabel) {
                    result.append(section.label()).append(";");
                }
            }
            result.append(row.cells().stream().map(c -> String.valueOf(c.value())).collect(Collectors.joining(";"))).append(";");
        }
        return result.toString();
    }

    private List<Section> leafSections(Section section) {
        ArrayList<Section> result = new ArrayList<Section>();
        if (section.sections().size() <= 0) {
            result.add(section);
        }
        section.sections().forEach(s -> result.addAll(this.leafSections((Section)s)));
        return result;
    }

    private String serializeCols(String dimension, List<Section> sections, List<Column> columns) {
        return String.format(Column, "") + (sections.size() > 1 ? String.format(Column, this.source.translate(dimension)) : "") + columns.stream().map(c -> String.format(Column, c.label())).collect(Collectors.joining(""));
    }

    private String serializeRows(List<Section> sections) {
        return sections.stream().map(s -> this.serializeRows((Section)s, this.rowsOf((Section)s, sections.size() > 1))).collect(Collectors.joining("\n"));
    }

    private String serializeRows(Section section, List<String> rows) {
        return String.join((CharSequence)"\n", rows);
    }

    private StringBuilder columnsDefinition(List<Column> columns) {
        StringBuilder columnsDefinitions = new StringBuilder();
        columnsDefinitions.append(String.format(RowLabelDefinition, 0, ""));
        for (int i = 0; i < columns.size(); ++i) {
            columnsDefinitions.append(String.format(ColumnDefinition, i + 1, columns.get(i).label()));
        }
        return columnsDefinitions;
    }

    private File tempFile(String extension) {
        try {
            return File.createTempFile(UUID.randomUUID().toString(), "." + extension);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }
}

