/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DataFormatter {
    private int minDecimals = -1;
    private int maxDecimals = 8;

    public DataFormatter decimals(int decimals) {
        if (decimals < 1) {
            return this;
        }
        this.minDecimals = decimals;
        this.maxDecimals = decimals;
        return this;
    }

    public String format(Double value, String lang) {
        return lang != null ? DataFormatter.formatterOf(lang, this.minDecimals, this.maxDecimals).format(value) : DataFormatter.rawFormat(value);
    }

    public String format(Long value, String lang) {
        return lang != null ? DataFormatter.formatterOf(lang).format(value) : DataFormatter.rawFormat(value);
    }

    private static String rawFormat(Object value) {
        return new BigDecimal(String.valueOf(value)).toPlainString();
    }

    private static DecimalFormat formatterOf(String lang) {
        return DataFormatter.formatterOf(lang, 0, 0);
    }

    private static DecimalFormat formatterOf(String lang, int minDecimals, int maxDecimals) {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setDecimalFormatSymbols(new DecimalFormatSymbols(DataFormatter.locale(lang)));
        if (minDecimals > 0) {
            formatter.setMinimumFractionDigits(minDecimals);
        }
        if (maxDecimals > 0) {
            formatter.setMaximumFractionDigits(maxDecimals);
        }
        return formatter;
    }

    private static Locale locale(String lang) {
        if (lang.equalsIgnoreCase("es")) {
            return Locale.of("es");
        }
        if (lang.equalsIgnoreCase("mx")) {
            return Locale.of("es", "MX");
        }
        return Locale.ENGLISH;
    }
}

