/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays.templates;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.filters.GroupFilter;
import io.intino.alexandria.ui.model.dynamictable.Section;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.datasources.CubeDatasource;
import io.intino.sumus.box.ui.datasources.MicroSiteBuilderOfCube;
import io.intino.sumus.box.ui.datasources.StoryboardDatasource;
import io.intino.sumus.box.ui.displays.DisplayHelper;
import io.intino.sumus.box.ui.displays.notifiers.StoryboardTemplateNotifier;
import io.intino.sumus.box.ui.displays.templates.AbstractStoryboardTemplate;
import io.intino.sumus.box.ui.displays.templates.StoryboardStepTemplate;
import io.intino.sumus.box.util.ParametersHelper;
import io.intino.sumus.box.util.TimetagHelper;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.model.IndicatorDefinition;
import io.intino.sumus.reporting.Storyboard;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class StoryboardTemplate
extends AbstractStoryboardTemplate<StoryboardTemplateNotifier, SumusBox> {
    private Storyboard storyboard;
    private Timetag period;
    private List<Dimension> dimensions = new ArrayList<Dimension>();
    private final Set<Dimension> readonlyDimensions = new HashSet<Dimension>();
    private List<CubeDatasource> sources = new ArrayList<CubeDatasource>();
    private Map<Dimension, List<String>> filters = new HashMap<Dimension, List<String>>();
    private IndicatorDefinition indicator;
    private boolean embedded = false;

    public StoryboardTemplate(SumusBox box) {
        super(box);
    }

    public void storyboard(String storyboardKey) {
        this.storyboard = ((SumusBox)this.box()).storyboard(storyboardKey);
        this.refresh();
    }

    public void open(String storyboardKey, boolean embedded) {
        this.open(storyboardKey, null, null, null, embedded);
    }

    public void open(String storyboardKey, String period, String dimensions, String filters, boolean embedded) {
        this.storyboard = ((SumusBox)this.box()).storyboard(storyboardKey);
        this.period = period != null ? new Timetag(period) : ((SumusBox)this.box()).ledgerRange((String)this.storyboard.ledger()).max;
        this.embedded = embedded;
        this.reloadSelection();
        this.registerDimensions(dimensions);
        this.registerFilters(filters);
        this.updateIndicator();
        this.updateSources(null);
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.indicatorSelector.onSelect(this::updateIndicator);
    }

    public void refresh() {
        super.refresh();
        this.title.visible(!this.embedded);
        if (this.title.isVisible()) {
            this.title.value(this.translate(this.storyboard.label()));
        }
        this.refreshIndicatorSelector();
        this.refreshSteps();
    }

    private void refreshIndicatorSelector() {
        this.indicatorSelector.clear();
        this.indicatorSelector.addAll(new ArrayList(this.storyboard.indicators().values().stream().map(this::translate).collect(Collectors.toList())));
    }

    private void refreshSteps() {
        List<Dimension> dimensionList = this.dimensions();
        List<Dimension> filteredDimensionList = dimensionList.stream().filter(this::dimensionIsNotInQuery).collect(Collectors.toList());
        this.steps.clear();
        for (int i = 0; i <= this.dimensions.size(); ++i) {
            Dimension current;
            Dimension dimension = current = i < this.dimensions.size() ? this.dimensions.get(i) : null;
            if (i >= dimensionList.size()) continue;
            this.fill(filteredDimensionList, current, (StoryboardStepTemplate)this.steps.add(), i);
        }
    }

    private void fill(List<Dimension> dimensions, Dimension dimension, StoryboardStepTemplate display, int index) {
        display.source(this.sources.size() > index ? this.sources.get(index) : null);
        display.indicatorLabelProvider(name -> this.translate(this.storyboard.indicators().get(name)));
        display.indicator(this.indicator.name());
        display.dimensionLabelProvider(name -> this.translate(this.storyboard.dimensions().get(name)));
        display.dimensions(dimensions);
        display.dimension(dimension);
        display.readonly(this.readonlyDimensions.contains(dimension));
        display.categories(this.filters.getOrDefault(dimension, new ArrayList()));
        display.onSelect(d -> this.updateDimensionSelection((Dimension)d, display, index));
        display.onShowDetails((d, categories) -> this.showDetails((Dimension)d, (List<String>)categories, display, index));
        display.onFilter((d, c) -> this.updateDimensionCategories((Dimension)d, (List<String>)c, display, index));
        display.refresh();
    }

    private Dimension dimension(String key) {
        return this.dimensions().stream().filter(d -> d.name().equals(key)).findFirst().orElse(null);
    }

    private List<Dimension> dimensions() {
        return this.ledger().dimensions().stream().filter(d -> this.storyboard.dimensions().containsKey(d.name())).sorted(Comparator.comparing(o -> this.translate(o.name()))).collect(Collectors.toList());
    }

    public String translate(String word) {
        Map<String, String> translations = ((SumusBox)this.box()).storyboardTranslations(this.storyboard.name(), this.language());
        return translations.containsKey(word) ? translations.get(word) : super.translate(word);
    }

    private Ledger ledger() {
        return ((SumusBox)this.box()).ledger(this.storyboard.ledger(), this.period);
    }

    private void reloadSelection() {
        this.dimensions.clear();
        this.readonlyDimensions.clear();
        this.sources.clear();
        this.filters.clear();
    }

    private void updateDimensionSelection(Dimension dimension, StoryboardStepTemplate display, int index) {
        this.register(dimension, index);
        if (dimension == null) {
            this.refresh();
            return;
        }
        this.updateSources(index - 1);
        display.source(this.sources.get(index));
        display.dimension(dimension);
        display.refresh();
    }

    private void showDetails(Dimension dimension, List<String> categories, StoryboardStepTemplate display, int index) {
        this.notifyUser(this.translate("Generating report. This operation may take time. Please wait..."), UserMessage.Type.Loading);
        CubeDatasource source = this.sources.get(index);
        Section section = new Section("Undivided");
        Timetag timetag = new Timetag(Instant.now(), Scale.Day);
        GroupFilter filter = new GroupFilter(dimension.name(), categories);
        MicroSiteBuilderOfCube builder = new MicroSiteBuilderOfCube((SumusBox)this.box(), DisplayHelper.cellProvider((SumusBox)this.box(), source), this.language());
        Iterator<Fact> details = source.details(source.timetag(), section, null, this.with(source.filters(), (Filter)filter));
        String result = builder.build(timetag, source.name(), source.title(), source.description(section.label(), null), source.itemColumns(), details);
        this.notifyUser(this.translate("Report generated"), UserMessage.Type.Success);
        String url = ((SumusBox)this.box()).configuration().url();
        this.openSite.site(url + (url.endsWith("/") ? "" : "/") + "drills/" + String.valueOf(timetag) + "/" + result + "/");
        this.openSite.launch();
    }

    private List<Filter> with(List<Filter> filters, Filter filter) {
        ArrayList<Filter> result = new ArrayList<Filter>(filters);
        result.add(filter);
        return result;
    }

    private void register(Dimension dimension, int index) {
        if (dimension == null) {
            this.dimensions = this.dimensions.subList(0, index);
            this.sources = this.sources.subList(0, index);
        } else {
            this.dimensions.add(dimension);
            this.sources.add(this.createSource(dimension));
        }
        this.filters = this.filters.entrySet().stream().filter(e -> this.hasDimension((Dimension)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void updateDimensionCategories(Dimension dimension, List<String> categories, StoryboardStepTemplate display, int index) {
        if (!categories.isEmpty()) {
            this.filters.put(dimension, categories);
        } else {
            this.filters.remove(dimension);
        }
        this.updateSources(dimension);
        this.refresh();
    }

    private boolean dimensionIsNotInQuery(Dimension dimension) {
        return this.dimensions.stream().noneMatch(d1 -> d1.name().equals(dimension.name()));
    }

    private StoryboardDatasource createSource(Dimension dimension) {
        StoryboardDatasource source = new StoryboardDatasource((SumusBox)this.box(), this.session(), this.storyboard, TimetagHelper.scaleFrom(this.period), this.period);
        if (dimension != null) {
            source.drill(dimension.name());
        }
        return source;
    }

    private void updateSources(int pos) {
        if (pos < 0) {
            return;
        }
        for (int j = pos + 1; j < this.sources.size(); ++j) {
            this.sources.get(j).filters(this.filtersTo(j));
        }
    }

    private void updateSources(Dimension dimension) {
        this.updateSources(this.posOf(dimension));
    }

    private List<Filter> filtersTo(int pos) {
        ArrayList<Filter> result = new ArrayList<Filter>();
        for (int i = pos - 1; i >= 0; --i) {
            Dimension dimension = this.dimensions.get(i);
            if (!this.filters.containsKey(dimension)) continue;
            result.add(this.filterOf(dimension));
        }
        return result.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private int posOf(Dimension dimension) {
        for (int i = 0; i < this.dimensions.size(); ++i) {
            if (this.dimensions.get(i) != dimension) continue;
            return i;
        }
        return this.dimensions.size();
    }

    private Filter filterOf(Dimension dimension) {
        return this.filters.containsKey(dimension) ? new GroupFilter(dimension.name(), this.filters.get(dimension)) : null;
    }

    private void updateIndicator() {
        Map<String, String> indicators = this.storyboard.indicators();
        Map.Entry<String, String> selected = !indicators.isEmpty() ? indicators.entrySet().iterator().next() : null;
        IndicatorDefinition indicatorDefinition = this.indicator = selected != null ? this.indicatorDefinitionOf(selected.getKey()) : null;
        if (this.indicator != null) {
            this.indicatorSelector.selection(new String[]{this.translate(selected.getValue())});
        }
    }

    private void updateIndicator(SelectionEvent event) {
        String selected = !event.selection().isEmpty() ? (String)event.selection().get(0) : null;
        String name = this.storyboard.indicators().entrySet().stream().filter(e -> this.translate((String)e.getValue()).equals(selected)).map(Map.Entry::getKey).findFirst().orElse(null);
        this.indicator = this.ledger().definition().indicators.stream().filter(i -> i.name().equals(name)).findFirst().orElse(null);
        this.refresh();
    }

    private List<Slice> toSlices(Map<Dimension, List<String>> filters) {
        return filters.entrySet().stream().map(e -> ((Dimension)e.getKey()).slices().stream().filter(s -> ((List)e.getValue()).contains(s.name())).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean hasDimension(Dimension dimension) {
        return this.dimensions.stream().anyMatch(d -> d.name().equals(dimension.name()));
    }

    private IndicatorDefinition indicatorDefinitionOf(String name) {
        return this.ledger().definition().indicators.stream().filter(i -> i.name().equals(name)).findFirst().orElse(null);
    }

    private void registerDimensions(String value) {
        ParametersHelper.toList(value).forEach(this::registerDimension);
    }

    private void registerDimension(String key) {
        Dimension dimension = this.dimension(key);
        this.dimensions.add(dimension);
        this.readonlyDimensions.add(dimension);
        this.sources.add(this.createSource(dimension));
    }

    private void registerFilters(String value) {
        this.filters.putAll(ParametersHelper.filtersToMap(value).entrySet().stream().collect(Collectors.toMap(e -> this.dimension((String)e.getKey()), e -> this.categoriesOf(this.dimension((String)e.getKey()), (List)e.getValue()))));
    }

    private List<String> categoriesOf(Dimension dimension, List<String> values) {
        if (values.contains("_All")) {
            return dimension.slices(1).stream().map(Slice::name).collect(Collectors.toList());
        }
        return values;
    }
}

