/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays.templates;

import io.intino.alexandria.Json;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.core.Box;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.displays.templates.AbstractStoryboardEntryTemplate;
import io.intino.sumus.box.util.StringHelper;
import io.intino.sumus.reporting.Storyboard;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StoryboardEntryTemplate
extends AbstractStoryboardEntryTemplate<SumusBox> {
    private String dashboard;
    private Storyboard storyboardDefinition;
    private Timetag period;
    private String node;

    public StoryboardEntryTemplate(Box box) {
        super((SumusBox)box);
    }

    public void dashboard(String dashboard) {
        this.dashboard = dashboard;
    }

    public void storyboard(Storyboard definition) {
        this.storyboardDefinition = definition;
    }

    public void period(Timetag period) {
        this.period = period;
    }

    public void node(String node) {
        this.node = node;
    }

    @Override
    public void init() {
        super.init();
        this.analyze.onOpen(e -> this.refreshStoryboardDialog());
    }

    public void refresh() {
        super.refresh();
        this.storyboardTitle.value(this.translate(this.storyboardDefinition.label()));
    }

    public String translate(String word) {
        Map<String, String> translations = ((SumusBox)this.box()).storyboardTranslations(this.storyboardDefinition.name(), this.language());
        return translations.containsKey(word) ? translations.get(word) : super.translate(word);
    }

    private void refreshStoryboardDialog() {
        String navigation = ((SumusBox)this.box()).dashboard(this.dashboard).navigation();
        Map filters = navigation != null ? Collections.singletonMap(navigation, Collections.singletonList(this.node)) : Collections.emptyMap();
        this.storyboardDialog.title(this.translate(this.storyboardDefinition.label()));
        this.storyboardStamp.open(this.storyboardDefinition.name(), this.period.value(), StringHelper.decode(Json.toString(navigation != null ? List.of(navigation) : Collections.emptyList())), StringHelper.encode(Json.toString(filters)), true);
        this.storyboardStamp.refresh();
    }
}

