/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays.templates;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.ui.displays.components.TemporalSlider;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.datasources.BaseCubeDatasource;
import io.intino.sumus.box.ui.datasources.CubeDatasource;
import io.intino.sumus.box.ui.datasources.Range;
import io.intino.sumus.box.ui.displays.DisplayHelper;
import io.intino.sumus.box.ui.displays.notifiers.CubeTemplateNotifier;
import io.intino.sumus.box.ui.displays.templates.AbstractCubeTemplate;
import io.intino.sumus.box.util.Formatters;
import io.intino.sumus.box.util.ParametersHelper;
import io.intino.sumus.box.util.TimetagHelper;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CubeTemplate
extends AbstractCubeTemplate<CubeTemplateNotifier, SumusBox> {
    private Map<String, String> labelCubeMap = new TreeMap<String, String>();
    private String cube;
    private Timetag timetag;
    private Boolean embedded;
    private boolean fromProxy = false;

    public CubeTemplate(SumusBox box) {
        super(box);
    }

    public void cube(String cube) {
        this.cube = cube;
        this.fromProxy = true;
    }

    public void embedded(String embedded) {
        this.embedded = embedded != null ? Boolean.valueOf(Boolean.parseBoolean(embedded)) : null;
        this.fromProxy = true;
    }

    public CubeTemplate open(String cube, boolean embedded) {
        this.cube = cube;
        this.refresh();
        this.updateCubeSelectorVisibility(!embedded);
        return this;
    }

    public CubeTemplate open(String cube, String period, String drill, String filters, boolean embedded) {
        this.selectCube(cube);
        if (drill != null) {
            this.cubeDialog.drillSelector.select(new String[]{this.cubeViewer.translate(((CubeDatasource)((Object)this.cubeViewer.source())).findDimension(drill).name())});
        }
        this.selectTimetag(new Timetag(period));
        this.cubeViewer.applyFilters(ParametersHelper.filtersToMap(filters));
        this.updateCubeSelectorVisibility(!embedded);
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.initPeriod();
        this.initCubeSelector();
        this.cubeDialog.onSelectTimetag(this::selectTimetag);
    }

    private void updateCubeSelectorVisibility(boolean isVisible) {
        this.cubeSelectorBlock.visible(isVisible);
        this.cubeSelector.selection(new String[]{this.cubeLabelOf(this.cube)});
    }

    public void refresh() {
        if (this.cube == null) {
            this.hideLoading();
            return;
        }
        if (this.fromProxy) {
            this.updateCubeSelectorVisibility(this.embedded == false);
        }
        this.showLoading();
        this.selectCube(this.cube);
        this.hideLoading();
    }

    private void initPeriod() {
        this.timetagEditor.onChange(e -> this.selectInstant((Instant)e.value()));
        this.initSlider(this.navigationSelector);
    }

    private void selectCube(String cube) {
        String cubeKey = this.cubeKeyOf(cube);
        Range range = ((SumusBox)this.box()).ledgerRange(cubeKey);
        this.noCubesMessage.visible(((SumusBox)this.box()).ledgers().isEmpty());
        if (range.min == null || range.max == null) {
            return;
        }
        this.refresh(this.sourceFor(cubeKey, range.max));
        this.selectTimetag(range.max);
    }

    private CubeDatasource sourceFor(String name, Timetag timetag) {
        CubeDatasource datasource = new CubeDatasource((SumusBox)this.box(), this.session(), name, TimetagHelper.scaleFrom(timetag));
        datasource.timetag(timetag);
        return datasource;
    }

    private void refresh(CubeDatasource source) {
        this.cubeViewer.dialog(this.cubeDialog);
        this.cubeViewer.source(source);
        this.cubeDialog.source(source);
        this.refreshPeriod(source);
        this.refreshCubeSelector();
    }

    private void showLoading() {
        this.loading.visible(true);
        this.cubeDialog.visible(false);
        this.cubeViewer.visible(false);
    }

    private void hideLoading() {
        boolean ledgersFound = ((SumusBox)this.box()).ledgers().size() > 0;
        this.loading.visible(false);
        this.cubeDialog.visible(ledgersFound);
        this.cubeViewer.visible(ledgersFound);
    }

    private void selectInstant(Instant instant) {
        Object source = this.cubeViewer.source();
        if (source == null) {
            return;
        }
        this.timetag = new Timetag(instant, ((BaseCubeDatasource)((Object)source)).scale());
        this.navigationSelector.value(Formatters.instantOf(this.timetag));
        this.cubeDialog.selectTimetag(this.timetag);
        this.notifyTimetagSelected();
    }

    public void selectTimetag(Timetag timetag) {
        Object source = this.cubeViewer.source();
        this.timetag = timetag;
        if (this.timetagEditor.value() != null && new Timetag(this.timetagEditor.value(), ((BaseCubeDatasource)((Object)source)).scale()).equals((Object)timetag)) {
            return;
        }
        this.timetagEditor.value(Formatters.instantOf(timetag));
        this.navigationSelector.value(Formatters.instantOf(timetag));
        this.cubeDialog.selectTimetag(timetag);
        this.notifyTimetagSelected();
    }

    private void initSlider(TemporalSlider slider) {
        slider.onChange(e -> {
            Object source = this.cubeViewer.source();
            if (source == null) {
                return;
            }
            this.selectTimetag(new Timetag((Instant)e.value(), ((BaseCubeDatasource)((Object)((Object)source))).scale()));
        });
        slider.formatter(value -> {
            Object source = this.cubeViewer.source();
            if (source == null) {
                return null;
            }
            return Timetag.of((LocalDateTime)LocalDateTime.ofInstant(Instant.ofEpochMilli(value), ZoneOffset.UTC), (Scale)((BaseCubeDatasource)((Object)((Object)source))).scale()).label();
        });
    }

    private void refreshPeriod(CubeDatasource source) {
        this.periodBlock.visible(((SumusBox)this.box()).ledgers().size() > 0);
        this.refreshSlider(source, this.navigationSelector);
        this.timetagEditor.pattern(DisplayHelper.pattern(source.scale()));
        this.timetagEditor.views(DisplayHelper.views(source.scale()));
        this.timetagEditor.value(Formatters.instantOf(this.navigationSelector.timetag()));
        this.timetagEditor.range(source.range().from(), this.rangeTo(source));
    }

    private void refreshSlider(CubeDatasource source, TemporalSlider slider) {
        Instant min = source.range().from();
        Instant max = this.rangeTo(source);
        slider.range(min, max);
        slider.value(source.timetag() != null ? Formatters.instantOf(source.timetag()) : max);
        slider.selectOrdinal(source.scale().name());
    }

    private Instant rangeTo(CubeDatasource source) {
        return source.range().to();
    }

    private void notifyTimetagSelected() {
        this.cubeViewer.updateTimetag(this.timetag);
    }

    private void initCubeSelector() {
        this.labelCubeMap = ((SumusBox)this.box()).labelLedgerMap();
        this.cubeSelector.onSelect(e1 -> {
            List selection = e1.selection();
            if (selection.isEmpty()) {
                return;
            }
            this.selectCube((String)e1.selection().get(0));
        });
    }

    private void refreshCubeSelector() {
        this.cubeSelector.clear();
        Set<String> ledgerLabels = this.labelCubeMap.keySet();
        ledgerLabels.forEach(label -> this.cubeSelector.add((String)label));
        if (this.cubeSelector.selection().isEmpty() && !ledgerLabels.isEmpty()) {
            this.cubeSelector.selection(new String[]{ledgerLabels.iterator().next()});
        }
    }

    private String cubeKeyOf(String cubeLabel) {
        return this.labelCubeMap.getOrDefault(cubeLabel, cubeLabel);
    }

    private String cubeLabelOf(String cubeKey) {
        return this.labelCubeMap.entrySet().stream().filter(e -> ((String)e.getValue()).equals(cubeKey)).findFirst().map(Map.Entry::getKey).orElse(cubeKey);
    }
}

