/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays.requesters;

import io.intino.alexandria.Json;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.requesters.DisplayRequester;
import io.intino.alexandria.ui.spark.UISparkManager;
import io.intino.sumus.box.schemas.MicrositeParams;
import io.intino.sumus.box.schemas.ViewFilterParams;
import io.intino.sumus.box.schemas.ViewNodeParams;
import io.intino.sumus.box.schemas.ViewParams;
import io.intino.sumus.box.ui.displays.ReportRenderer;

public class ReportRendererRequester
extends DisplayRequester {
    public ReportRendererRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    public void execute() throws AlexandriaException {
        ReportRenderer display = (ReportRenderer)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("openMicrosite")) {
            display.openMicrosite((MicrositeParams)Json.fromString((String)this.manager.fromQuery("v"), MicrositeParams.class));
            return;
        }
        if (operation.equals("openNode")) {
            display.openNode(this.manager.fromQuery("v"));
            return;
        }
        if (operation.equals("openView")) {
            display.openView((ViewParams)Json.fromString((String)this.manager.fromQuery("v"), ViewParams.class));
            return;
        }
        if (operation.equals("openViewNode")) {
            display.openViewNode((ViewNodeParams)Json.fromString((String)this.manager.fromQuery("v"), ViewNodeParams.class));
            return;
        }
        if (operation.equals("openViewFilter")) {
            display.openViewFilter((ViewFilterParams)Json.fromString((String)this.manager.fromQuery("v"), ViewFilterParams.class));
            return;
        }
        if (operation.equals("openReport")) {
            display.openReport(this.manager.fromQuery("v"));
            return;
        }
        if (operation.equals("selectScale")) {
            display.selectScale(this.manager.fromQuery("v"));
            return;
        }
        if (operation.equals("selectWindow")) {
            display.selectWindow(this.manager.fromQuery("v"));
            return;
        }
        if (operation.equals("selectPeriod")) {
            display.selectPeriod(this.manager.fromQuery("v"));
            return;
        }
        super.execute();
    }
}

