/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.dynamictable.Column;
import io.intino.alexandria.ui.model.dynamictable.Row;
import io.intino.alexandria.ui.model.dynamictable.Section;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.schemas.CubeBarChartInfo;
import io.intino.sumus.box.schemas.CubeBarChartSelection;
import io.intino.sumus.box.schemas.CubeBarChartSerie;
import io.intino.sumus.box.ui.datasources.CubeDatasource;
import io.intino.sumus.box.ui.displays.AbstractCubeBarChart;
import io.intino.sumus.box.ui.displays.notifiers.CubeBarChartNotifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class CubeBarChart
extends AbstractCubeBarChart<SumusBox> {
    private CubeDatasource source;
    private final CubeBarChartSelection selection = new CubeBarChartSelection().drill(new ArrayList<String>()).divideBy(new ArrayList<String>());
    private String sort;
    private CubeBarChartInfo.Mode mode = CubeBarChartInfo.Mode.Olap;
    private Consumer<List<String>> selectDrillCategoryListener;

    public CubeBarChart(SumusBox box) {
        super(box);
    }

    public CubeBarChart source(CubeDatasource source) {
        this.source = source;
        this.selection.indicator(!source.columns().isEmpty() ? source.columns().get(0).label() : null);
        return this;
    }

    public CubeBarChart mode(CubeBarChartInfo.Mode mode) {
        this.mode = mode;
        return this;
    }

    public CubeBarChart onSelectDrillCategory(Consumer<List<String>> listener) {
        this.selectDrillCategoryListener = listener;
        return this;
    }

    public CubeBarChart timetag(Timetag timetag) {
        this.source.timetag(timetag);
        return this;
    }

    public CubeBarChart drill(String drill) {
        this.source.drill(drill);
        this.selection.drill(this.drillCategories());
        return this;
    }

    public CubeBarChart zoomLevel(int zoomLevel) {
        this.source.zoomLevel(zoomLevel);
        return this;
    }

    public CubeBarChart divideBy(String divideBy) {
        this.source.dimension(divideBy);
        this.selection.divideBy(this.divideByCategories());
        return this;
    }

    public void selectIndicator(String indicator) {
        this.indicator(indicator);
        this.refresh();
    }

    public void indicator(String indicator) {
        this.selection.indicator(indicator);
    }

    public void drillCategories(List<String> categories) {
        this.selection.drill(new ArrayList<String>(categories));
    }

    public void updateDrillCategoriesSelection(List<String> categories) {
        this.selection.drill(new ArrayList<String>(categories));
        ((CubeBarChartNotifier)this.notifier).refreshSelection(this.selection);
    }

    public void selectDrillCategory(String category) {
        if (this.selection.drill().contains(category)) {
            this.selection.drill().remove(category);
        } else {
            this.selection.drill().add(category);
        }
        this.notifyDrillCategorySelected();
    }

    public void selectDrillCategories(List<String> categories) {
        this.selection.drill().clear();
        this.selection.drill().addAll(categories);
        this.notifyDrillCategorySelected();
    }

    public void unselectDrillCategory(String category) {
        this.selection.drill().remove(category);
        this.notifyDrillCategorySelected();
    }

    public void selectDivideByCategory(String category) {
        if (this.selection.divideBy().contains(category)) {
            this.selection.divideBy().remove(category);
        } else {
            this.selection.divideBy().add(category);
        }
        this.refresh();
    }

    public void sort(String sort) {
        this.sort = sort;
    }

    public void showLoading() {
        ((CubeBarChartNotifier)this.notifier).showLoading();
    }

    public void refresh() {
        super.refresh();
        ((CubeBarChartNotifier)this.notifier).showLoading();
        ((CubeBarChartNotifier)this.notifier).refresh(this.info());
        ((CubeBarChartNotifier)this.notifier).refreshSelection(this.selection);
        ((CubeBarChartNotifier)this.notifier).refreshSeries(this.series());
        ((CubeBarChartNotifier)this.notifier).hideLoading();
    }

    private List<String> indicators() {
        return this.source.columns().stream().map(Column::label).collect(Collectors.toList());
    }

    private CubeBarChartInfo info() {
        List<String> indicators = this.indicators();
        List<String> drillCategories = this.drillCategories();
        List<String> divideByCategories = this.divideByCategories();
        CubeBarChartInfo result = new CubeBarChartInfo();
        result.indicators(indicators);
        result.drillCategories(drillCategories);
        result.divideByCategories(divideByCategories);
        result.sort(this.sort);
        result.mode(this.mode);
        return result;
    }

    private List<String> toString(List<Group> categories) {
        return categories.stream().map(Group::label).collect(Collectors.toList());
    }

    private List<CubeBarChartSerie> series() {
        if (this.selection.indicator() == null) {
            return Collections.singletonList(this.emptySerie());
        }
        List<Section> sections = this.source.sections();
        if (sections.isEmpty()) {
            return Collections.singletonList(this.emptySerie());
        }
        List<String> categories = this.divideByCategories();
        return sections.stream().filter(s -> categories.isEmpty() || categories.contains(s.label())).map(this::serieOf).collect(Collectors.toList());
    }

    private CubeBarChartSerie serieOf(Section section) {
        List<Double> values = this.drillCategories().stream().map(c -> {
            Row row = this.findRow(section.rows(), (String)c);
            return row != null ? row.cell(this.selection.indicator()).value() : 0.0;
        }).collect(Collectors.toList());
        return this.serie(section.label(), values);
    }

    private Row findRow(List<Row> rows, String drill) {
        return rows.stream().filter(r -> r.label().equals(drill)).findFirst().orElse(null);
    }

    private CubeBarChartSerie emptySerie() {
        long count = this.source.drillAfterTranspose() != null ? this.source.slices(this.source.drillAfterTranspose()).stream().count() : 0L;
        ArrayList<Double> result = new ArrayList<Double>();
        int i = 0;
        while ((long)i < count) {
            result.add(0.0);
            ++i;
        }
        return this.addThemeProperties(new CubeBarChartSerie().name("").values(result));
    }

    private String language() {
        return this.session().discoverLanguage();
    }

    private List<String> drillCategories() {
        if (this.source.drillAfterTranspose() == null) {
            return Collections.emptyList();
        }
        return this.toString(this.source.groups(this.source.drillAfterTranspose()));
    }

    private List<String> divideByCategories() {
        if (this.source.dimensionAfterTranspose() == null) {
            return Collections.emptyList();
        }
        return this.source.dimensionAfterTranspose() != null && !this.source.dimensionAfterTranspose().equals("Undivided") ? this.toString(this.source.groups(this.source.dimensionAfterTranspose())) : Collections.emptyList();
    }

    private CubeBarChartSerie serie(String name, List<Double> values) {
        return this.addThemeProperties(new CubeBarChartSerie().name(name).values(values));
    }

    private CubeBarChartSerie addThemeProperties(CubeBarChartSerie serie) {
        String color = ((SumusBox)this.box()).theme().getOrDefault("section.color", "black");
        String backgroundColor = ((SumusBox)this.box()).theme().getOrDefault("section.backgroundColor", "#DDDDDD");
        return serie.color(color).backgroundColor(backgroundColor).fontSize(9);
    }

    private void notifyDrillCategorySelected() {
        if (this.selectDrillCategoryListener == null) {
            return;
        }
        this.selectDrillCategoryListener.accept(this.selection.drill());
    }
}

