/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.datasources;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.ui.model.TimeScale;
import io.intino.alexandria.ui.model.dynamictable.Column;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.datasources.CubeDatasource;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.model.CompositeIndicatorDefinition;
import io.intino.sumus.engine.model.SimpleIndicatorDefinition;
import io.intino.sumus.reporting.Storyboard;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StoryboardDatasource
extends CubeDatasource {
    private final Storyboard storyboard;

    public StoryboardDatasource(SumusBox box, UISession session, Storyboard storyboard, TimeScale scale) {
        super(box, session, storyboard.ledger(), scale);
        this.storyboard = storyboard;
        this.translations(box.storyboardTranslations(storyboard.name(), this.language()));
    }

    public StoryboardDatasource(SumusBox box, UISession session, Storyboard storyboard, TimeScale scale, Timetag timetag) {
        super(box, session, storyboard.ledger(), scale, timetag);
        this.storyboard = storyboard;
        this.translations(box.storyboardTranslations(storyboard.name(), this.language()));
    }

    @Override
    public List<Column> columns() {
        List indicatorList = this.ledgerDefinition().indicators;
        return indicatorList.stream().filter(c -> this.storyboard.indicators().containsKey(c.name())).map(this::columnOf).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public List<Dimension> dimensions() {
        return super.dimensions().stream().filter(d -> this.storyboard.dimensions().containsKey(d.name())).collect(Collectors.toList());
    }

    @Override
    public String columnName(String label) {
        Map.Entry entry = this.storyboard.indicators().entrySet().stream().filter(e -> this.translate((String)e.getValue()).equals(label)).findFirst().orElse(null);
        return entry != null ? (String)entry.getKey() : label;
    }

    @Override
    protected Column columnOf(SimpleIndicatorDefinition indicator) {
        return new Column(this.translate(this.storyboard.indicators().get(indicator.name())), this.operatorOf(indicator.formula())).metric(indicator.unit());
    }

    @Override
    protected Column columnOf(CompositeIndicatorDefinition indicator) {
        return new Column(this.translate(this.storyboard.indicators().get(indicator.name())), this.operatorOf(indicator)).metric(indicator.unit());
    }
}

