/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.datasources;

import io.intino.sumus.box.I18n;
import java.util.Objects;

public class ItemColumn {
    public final String label;
    public final Type type;
    private final String extraData;

    public ItemColumn(String label, Type type) {
        this(label, type, null);
    }

    public ItemColumn(String label, Type type, String extraData) {
        this.label = label;
        this.type = type;
        this.extraData = extraData;
    }

    public String label(String language) {
        return I18n.translate(this.label, language);
    }

    public Type type() {
        return this.type;
    }

    public String extraData() {
        return this.extraData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemColumn)) {
            return false;
        }
        ItemColumn that = (ItemColumn)o;
        return Objects.equals(this.label, that.label);
    }

    public int hashCode() {
        return Objects.hash(this.label);
    }

    public static enum Type {
        Text,
        Number,
        Link;

    }
}

