/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.serializers.ledger;

import io.intino.sumus.box.serializers.ledger.AttributeSerializer;
import io.intino.sumus.box.serializers.ledger.DimensionSerializer;
import io.intino.sumus.box.serializers.ledger.IndicatorSerializer;
import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.DimensionDefinition;
import io.intino.sumus.engine.model.IndicatorDefinition;
import io.intino.sumus.engine.model.LedgerDefinition;
import io.intino.sumus.model.AbstractLedger;
import io.intino.sumus.model.Ledger;
import java.util.Arrays;
import java.util.Collection;

public class LedgerSerializer {
    public LedgerDefinition serialize(Ledger ledger) {
        LedgerDefinition definition = new LedgerDefinition(LedgerSerializer.contentOf(ledger), LedgerSerializer.formatOf(ledger), this.aggregationOf(ledger), ledger.label(), ledger.description());
        definition.attributes.addAll(this.attributes(ledger));
        definition.indicators.addAll(this.indicators(ledger));
        definition.dimensions.addAll(this.dimensions(ledger));
        return definition;
    }

    private Collection<? extends AttributeDefinition> attributes(Ledger ledger) {
        return new AttributeSerializer().serialize(ledger);
    }

    private Collection<? extends IndicatorDefinition> indicators(Ledger ledger) {
        return new IndicatorSerializer().serialize(ledger);
    }

    private Collection<? extends DimensionDefinition> dimensions(Ledger ledger) {
        return new DimensionSerializer().serialize(ledger);
    }

    private LedgerDefinition.Aggregation aggregationOf(Ledger ledger) {
        if (!ledger.isAggregation()) {
            return null;
        }
        Ledger.Aggregation aggregation = ledger.asAggregation();
        return new LedgerDefinition.Aggregation(this.periodOf(aggregation.aggregationPeriod()), aggregation.baseLedger().id(), aggregation.aggregationKey() != null ? aggregation.aggregationKey().name$() : null, null);
    }

    private static LedgerDefinition.Content contentOf(Ledger ledger) {
        AbstractLedger.Content content = ledger.content();
        if (content == null) {
            return LedgerDefinition.Content.Status;
        }
        return Arrays.stream(LedgerDefinition.Content.values()).filter(c -> c.name().equalsIgnoreCase(content.name())).findFirst().orElse(LedgerDefinition.Content.Status);
    }

    private static LedgerDefinition.Format formatOf(Ledger ledger) {
        AbstractLedger.Format format = ledger.format();
        if (format == null) {
            return LedgerDefinition.Format.Tsv;
        }
        return Arrays.stream(LedgerDefinition.Format.values()).filter(f -> f.name().equalsIgnoreCase(format.name())).findFirst().orElse(LedgerDefinition.Format.Tsv);
    }

    private LedgerDefinition.Aggregation.Period periodOf(AbstractLedger.AbstractAggregation.AggregationPeriod period) {
        return Arrays.stream(LedgerDefinition.Aggregation.Period.values()).filter(p -> p.name().equalsIgnoreCase(period.name())).findFirst().orElse(null);
    }
}

