/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.serializers.ledger;

import io.intino.alexandria.logger.Logger;
import io.intino.sumus.box.serializers.ledger.AttributeSerializer;
import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.CompositeIndicatorDefinition;
import io.intino.sumus.engine.model.IndicatorDefinition;
import io.intino.sumus.engine.model.SimpleIndicatorDefinition;
import io.intino.sumus.model.Indicator;
import io.intino.sumus.model.Ledger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class IndicatorSerializer {
    public Collection<? extends IndicatorDefinition> serialize(Ledger ledger) {
        return ledger.indicatorList().stream().map(this::serialize).filter(Objects::nonNull).toList();
    }

    public IndicatorDefinition serialize(Indicator indicator) {
        if (indicator.isAttributeIndicator()) {
            return this.serialize(indicator.asAttributeIndicator());
        }
        if (indicator.isFormula()) {
            return this.serialize(indicator.asFormula());
        }
        return null;
    }

    private IndicatorDefinition serialize(Indicator.AttributeIndicator indicator) {
        return new SimpleIndicatorDefinition(indicator.name$(), this.functionOf(indicator), IndicatorSerializer.attribute(indicator), indicator.unit(), this.scaleOf(indicator.asIndicator()), this.filteredValues(indicator), Integer.valueOf(indicator.decimals()));
    }

    private IndicatorDefinition serialize(Indicator.Formula indicator) {
        return new CompositeIndicatorDefinition(indicator.name$(), indicator.formula(), indicator.unit(), this.scaleOf(indicator.asIndicator()), Integer.valueOf(indicator.decimals()));
    }

    private SimpleIndicatorDefinition.Function functionOf(Indicator.AttributeIndicator indicator) {
        Indicator i = indicator.asIndicator();
        if (i.isCount()) {
            return SimpleIndicatorDefinition.Function.Count;
        }
        if (i.isSum()) {
            return SimpleIndicatorDefinition.Function.Sum;
        }
        if (i.isAverage()) {
            return SimpleIndicatorDefinition.Function.Avg;
        }
        if (i.isRatio()) {
            return SimpleIndicatorDefinition.Function.Ratio;
        }
        if (i.isMax()) {
            return SimpleIndicatorDefinition.Function.Max;
        }
        if (i.isMin()) {
            return SimpleIndicatorDefinition.Function.Min;
        }
        return null;
    }

    private static AttributeDefinition attribute(Indicator.AttributeIndicator indicator) {
        return new AttributeSerializer().serialize(indicator.attribute());
    }

    private IndicatorDefinition.Scale scaleOf(Indicator indicator) {
        if (indicator.scale() == null) {
            return null;
        }
        try {
            String[] data = indicator.scale().split(":");
            return new IndicatorDefinition.Scale(Double.parseDouble(data[0]), Double.parseDouble(data[1]));
        }
        catch (Throwable e) {
            Logger.warn((String)("Error parsing scale '" + indicator.scale() + "'"));
            return null;
        }
    }

    private List<String> filteredValues(Indicator.AttributeIndicator indicator) {
        Indicator i = indicator.asIndicator();
        if (!i.isFilterableIndicator()) {
            return Collections.emptyList();
        }
        Indicator.FilterableIndicator filterable = i.asFilterableIndicator();
        return filterable.value() != null ? Collections.singletonList(filterable.value()) : Collections.emptyList();
    }
}

