/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.serializers.ledger;

import io.intino.alexandria.logger.Logger;
import io.intino.sumus.box.serializers.ledger.AttributeSerializer;
import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.DimensionDefinition;
import io.intino.sumus.model.Attribute;
import io.intino.sumus.model.Dimension;
import io.intino.sumus.model.Ledger;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DimensionSerializer {
    static final String Diacrit = "~";
    static final String OpenBracket = "[";
    static final String CloseBracket = "]";
    static final String OpenParenthesis = "(";
    static final String CloseParenthesis = ")";

    public Collection<? extends DimensionDefinition> serialize(Ledger ledger) {
        return ledger.dimensionList().stream().map(this::serialize).filter(Objects::nonNull).toList();
    }

    private DimensionDefinition serialize(Dimension dimension) {
        if (dimension.isNumericalDimension()) {
            return this.serialize(dimension.asNumericalDimension());
        }
        return null;
    }

    private DimensionDefinition serialize(Dimension.NumericalDimension dimension) {
        try {
            Map<String, String> categories = this.categories(dimension.asDimension());
            return new DimensionDefinition.Numerical(dimension.name$(), DimensionSerializer.attribute(dimension), new HashMap()).categoryRange(categories);
        }
        catch (Throwable e) {
            Logger.warn((String)e.getMessage());
            return null;
        }
    }

    private static AttributeDefinition attribute(Dimension.NumericalDimension dimension) {
        Attribute attribute = (Attribute)dimension.attribute().a$(Attribute.class);
        return attribute != null ? new AttributeSerializer().serialize(attribute) : null;
    }

    private Map<String, String> categories(Dimension dimension) {
        return dimension.isExplicit() ? this.categories(dimension.asExplicit()) : this.categories(dimension.asImplicit());
    }

    private Map<String, String> categories(Dimension.Explicit dimension) {
        return dimension.sliceList().stream().collect(Collectors.toMap(Dimension.Explicit.Slice::label, s -> s.range().replace("..", ","), (a, b) -> a, LinkedHashMap::new));
    }

    private Map<String, String> categories(Dimension.Implicit dimension) {
        LinkedHashMap<String, String> categories = new LinkedHashMap<String, String>();
        String[] ranges = dimension.ranges().split(" ");
        for (int i = 0; i < ranges.length - 1; ++i) {
            String start = ranges[i];
            String end = ranges[i + 1];
            String name = this.rangeName(start, end);
            String range = DimensionSerializer.range(i, start, end, ranges);
            categories.put(name, range);
        }
        return categories;
    }

    private String rangeName(String start, String end) {
        return OpenBracket + this.clean(start) + ".." + this.clean(end) + CloseBracket;
    }

    private static String range(int i, String start, String end, String[] ranges) {
        boolean isFirst = i == 0;
        boolean isLast = i + 1 == ranges.length - 1;
        Object range = isFirst && start.equals(Diacrit) ? OpenParenthesis : OpenBracket;
        range = (String)range + start + "," + end;
        range = (String)range + (!isLast ? CloseParenthesis : (end.equals(Diacrit) ? CloseParenthesis : CloseBracket));
        return range;
    }

    private String clean(String value) {
        return value == null || value.equals(Diacrit) ? "" : value;
    }
}

