/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.serializers.ledger;

import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.model.Attribute;
import io.intino.sumus.model.Ledger;
import java.util.Collection;
import java.util.Objects;

public class AttributeSerializer {
    public Collection<? extends AttributeDefinition> serialize(Ledger ledger) {
        return ledger.attributeList().stream().map(this::serialize).filter(Objects::nonNull).toList();
    }

    public AttributeDefinition serialize(Attribute attribute) {
        if (attribute.isCategory()) {
            return new AttributeDefinition.Category(attribute.name$());
        }
        if (attribute.isInt()) {
            return new AttributeDefinition.Int(attribute.name$());
        }
        if (attribute.isReal()) {
            return new AttributeDefinition.Real(attribute.name$());
        }
        if (attribute.isDate()) {
            return new AttributeDefinition.Date(attribute.name$());
        }
        if (attribute.isTime_()) {
            return new AttributeDefinition.Time(attribute.name$());
        }
        if (attribute.isLabel()) {
            return new AttributeDefinition.Label(attribute.name$());
        }
        if (attribute.isURL()) {
            return new AttributeDefinition.Url(attribute.name$(), attribute.asURL().basePath());
        }
        if (attribute.isKey()) {
            Ledger baseLedger = attribute.asKey().join();
            return new AttributeDefinition.Key(attribute.name$(), baseLedger != null ? baseLedger.id() : null);
        }
        return null;
    }
}

