/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.serializers.dashboard;

import io.intino.magritte.framework.Layer;
import io.intino.sumus.box.serializers.SyntaxHelper;
import io.intino.sumus.model.Report;
import io.intino.sumus.reporting.model.ViewDefinition;
import java.util.List;

class ViewSerializer {
    ViewSerializer() {
    }

    public List<ViewDefinition> serialize(List<Report.Insight> insights) {
        return insights.stream().filter(i -> i.i$(Report.ViewCharts.class)).map(i -> (Report.ViewCharts)i.a$(Report.ViewCharts.class)).map(this::serialize).toList();
    }

    public ViewDefinition serialize(Report.ViewCharts view) {
        ViewDefinition definition = new ViewDefinition();
        definition.name = view.cube().id();
        definition.label = view.label();
        definition.ledger = view.cube().ledger().id();
        definition.dimensions = (String[])view.cube().dimensions().stream().map(Layer::name$).toArray(String[]::new);
        definition.filters = (String[])view.cube().sliceFilterList().stream().map(SyntaxHelper::sliceSyntax).toArray(String[]::new);
        definition.dateFilters = (String[])view.cube().datesFilterList().stream().flatMap(f -> SyntaxHelper.rangeSyntax(f).stream()).toArray(String[]::new);
        definition.indicators = (String[])view.indicators().stream().map(Layer::name$).toArray(String[]::new);
        definition.scale = view.temporality().step().unit().name();
        definition.level = ViewSerializer.omitIfNegative(view.level());
        return definition;
    }

    private static Integer omitIfNegative(int maxItems) {
        return maxItems > -1 ? Integer.valueOf(maxItems) : null;
    }
}

