/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.serializers.dashboard;

import io.intino.sumus.box.SumusArchetype;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.serializers.SyntaxHelper;
import io.intino.sumus.box.serializers.dashboard.InsightSerializer;
import io.intino.sumus.box.serializers.dashboard.ViewSerializer;
import io.intino.sumus.model.AbstractReport;
import io.intino.sumus.model.AbstractStoryboard;
import io.intino.sumus.model.Dashboard;
import io.intino.sumus.model.Report;
import io.intino.sumus.reporting.model.InsightDefinition;
import io.intino.sumus.reporting.model.ReportDefinition;
import io.intino.sumus.reporting.model.ViewDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ReportSerializer {
    private final SumusArchetype archetype;
    private final Dashboard dashboard;

    public ReportSerializer(SumusBox box, Dashboard dashboard) {
        this.archetype = box.archetype();
        this.dashboard = dashboard;
    }

    public ReportDefinition serialize(Report report) {
        ReportDefinition definition = new ReportDefinition();
        definition.name = report.label();
        definition.label = report.label();
        definition.group = this.dashboard.groupLabel(report);
        definition.description = report.description();
        definition.template = this.archetype.dashboardTemplateFile(this.dashboard.id(), report.id()).getAbsolutePath();
        definition.visibility = SyntaxHelper.visibilityOf(report.visibility());
        definition.scales = (String[])report.scales().stream().map(Enum::name).toArray(String[]::new);
        definition.locale = report.locale();
        definition.requireAllLedgers = report.isAllLedgersRequired();
        definition.isSingleton = report.isSingleton();
        definition.isRealtime = report.isRealtime();
        Map<String, String> patternID = this.patternIDOf(report.insightList());
        definition.patterns = ReportSerializer.swap(patternID);
        definition.insights = this.insights(report, patternID);
        definition.views = this.views(report);
        definition.storyboards = (String[])report.storyboards().stream().map(AbstractStoryboard::id).toArray(String[]::new);
        return definition;
    }

    private InsightDefinition[] insights(Report report, Map<String, String> patternNames) {
        return (InsightDefinition[])new InsightSerializer(patternNames).serialize(report.insightList()).toArray(InsightDefinition[]::new);
    }

    private ViewDefinition[] views(Report report) {
        return (ViewDefinition[])new ViewSerializer().serialize(report.insightList()).toArray(ViewDefinition[]::new);
    }

    private Map<String, String> patternIDOf(List<Report.Insight> insights) {
        HashMap<String, String> patternID = new HashMap<String, String>();
        insights.stream().filter(AbstractReport.AbstractInsight::isFormatted).map(AbstractReport.AbstractInsight::asFormatted).flatMap(f -> f.formatList().stream()).filter(f -> f.pattern() != null && !f.pattern().isEmpty()).forEach(f -> {
            String name = "p" + patternID.size();
            patternID.putIfAbsent(f.pattern(), name);
        });
        return patternID;
    }

    protected static <T> Map<T, T> swap(Map<T, T> map) {
        return map.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (a, b) -> a));
    }
}

