/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.serializers.dashboard;

import io.intino.magritte.framework.Layer;
import io.intino.sumus.box.serializers.SyntaxHelper;
import io.intino.sumus.box.serializers.dashboard.OptionsSerializer;
import io.intino.sumus.model.Report;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.model.InsightDefinition;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class InsightSerializer {
    private final Map<String, String> patternIDMap;

    public InsightSerializer(Map<String, String> patternIDMap) {
        this.patternIDMap = patternIDMap;
    }

    public List<InsightDefinition> serialize(List<Report.Insight> insights) {
        return insights.stream().map(this::serialize).toList();
    }

    public InsightDefinition serialize(Report.Insight insight) {
        InsightDefinition definition = new InsightDefinition();
        definition.id = insight.name$();
        definition.label = insight.label();
        definition.ledger = insight.cube().ledger().id();
        definition.type = this.type(insight);
        definition.visibility = SyntaxHelper.visibilityOf(insight.visibility());
        definition.dimensions = (String[])insight.cube().dimensions().stream().map(Layer::name$).toArray(String[]::new);
        definition.filters = (String[])insight.cube().sliceFilterList().stream().map(SyntaxHelper::sliceSyntax).toArray(String[]::new);
        definition.dateFilters = (String[])insight.cube().datesFilterList().stream().flatMap(f -> SyntaxHelper.rangeSyntax(f).stream()).toArray(String[]::new);
        definition.indicators = (String[])insight.indicators().stream().map(Layer::name$).toArray(String[]::new);
        definition.level = InsightSerializer.omitIfNegative(insight.level());
        definition.node = insight.cube().filterNode() != null ? insight.cube().filterNode().type().name() : null;
        definition.options = OptionsSerializer.serialize(insight);
        if (insight.isOrdered() && this.isValid(insight.asOrdered())) {
            definition.order = SyntaxHelper.orderSyntax(insight.asOrdered());
        }
        if (insight.isLabeled()) {
            definition.labels = this.labelsMap(insight.asLabeled());
        }
        if (insight.isSliced()) {
            definition.slices = (String[])insight.asSliced().slices().toArray(String[]::new);
        }
        if (insight.isFormatted()) {
            definition.formats = (String[])this.formats(insight.asFormatted()).toArray(String[]::new);
        }
        if (insight.i$(Report.Limitable.class)) {
            definition.maxItems = InsightSerializer.omitIfNegative(((Report.Limitable)insight.a$(Report.Limitable.class)).maxItems());
        }
        return definition;
    }

    private Dashboard.Insight.Type type(Report.Insight insight) {
        if (insight.i$(Report.TableBar.class)) {
            return Dashboard.Insight.Type.TableBar;
        }
        if (insight.i$(Report.Table.class)) {
            return Dashboard.Insight.Type.Table;
        }
        if (insight.i$(Report.Pie.class)) {
            return Dashboard.Insight.Type.Pie;
        }
        if (insight.i$(Report.Gauge.class)) {
            return Dashboard.Insight.Type.Gauge;
        }
        if (insight.i$(Report.StackedColumn.class)) {
            return Dashboard.Insight.Type.StackedColumn;
        }
        if (insight.i$(Report.Column.class)) {
            return Dashboard.Insight.Type.Column;
        }
        if (insight.i$(Report.Microsite.class)) {
            return Dashboard.Insight.Type.Microsite;
        }
        if (insight.i$(Report.Json.class)) {
            return Dashboard.Insight.Type.Json;
        }
        if (insight.i$(Report.List.class)) {
            return Dashboard.Insight.Type.List;
        }
        if (insight.i$(Report.TableView.class)) {
            return Dashboard.Insight.Type.TableView;
        }
        if (insight.i$(Report.LineView.class)) {
            return Dashboard.Insight.Type.LineView;
        }
        if (insight.i$(Report.HeatmapView.class)) {
            return Dashboard.Insight.Type.HeatmapView;
        }
        if (insight.i$(Report.ColumnSwapView.class)) {
            return Dashboard.Insight.Type.ColumnSwapView;
        }
        if (insight.i$(Report.ColumnView.class)) {
            return Dashboard.Insight.Type.ColumnView;
        }
        return null;
    }

    private List<String> formats(Report.Insight.Formatted formatted) {
        return formatted.formatList().stream().flatMap(f -> this.formats((Report.Insight.Formatted.Format)((Object)f)).stream()).collect(Collectors.toList());
    }

    private List<String> formats(Report.Insight.Formatted.Format format) {
        String id = this.patternIDMap.get(format.pattern());
        return id != null ? format.indicators().stream().map(indicator -> SyntaxHelper.formatSyntax(indicator, id)).toList() : Collections.emptyList();
    }

    private Map<String, String> labelsMap(Report.Insight.Labeled labeled) {
        return labeled.labelList().stream().collect(Collectors.toMap(l -> l.old(), l -> l.new$(), (a, b) -> a));
    }

    private boolean isValid(Report.Insight.Ordered ordered) {
        if (ordered.order() == null) {
            return false;
        }
        return ordered.orderBy() != null || !ordered.order().requiresIndicator();
    }

    private static Integer omitIfNegative(int maxItems) {
        return maxItems > -1 ? Integer.valueOf(maxItems) : null;
    }
}

