/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.serializers.dashboard;

import io.intino.sumus.box.SumusArchetype;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.model.AbstractReport;
import io.intino.sumus.model.Dashboard;
import io.intino.sumus.reporting.model.DashboardDefinition;

public class DashboardSerializer {
    private final SumusArchetype archetype;

    public DashboardSerializer(SumusBox box) {
        this.archetype = box.archetype();
    }

    public DashboardDefinition serialize(Dashboard dashboard) {
        DashboardDefinition definition = new DashboardDefinition();
        definition.name = dashboard.label();
        definition.datamart = this.archetype.datamarts().ledgers().root().getAbsolutePath();
        definition.template = this.archetype.dashboardTemplateFile(dashboard.id(), "base").getAbsolutePath();
        definition.reportDefinitions = (String[])dashboard.groupList().stream().flatMap(g -> g.reports().stream()).map(AbstractReport::id).toArray(String[]::new);
        definition.isRealtime = dashboard.isRealtime();
        definition.locale = dashboard.locale();
        if (dashboard.isNavigable()) {
            Dashboard.Navigable navigable = dashboard.asNavigable();
            definition.navigation = navigable.navigation().name$();
            definition.nodes = (String[])navigable.nodes().toArray(String[]::new);
        }
        return definition;
    }
}

