/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.serializers.calendar;

import io.intino.sumus.box.serializers.SyntaxHelper;
import io.intino.sumus.model.WeekCalendar;
import java.time.LocalDate;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class WeekCalendarSerializer {
    private static void serialize(WeekCalendar.Year year, Map<LocalDate, String> map) {
        year.weekList().forEach(week -> {
            LocalDate date = WeekCalendarSerializer.dateOf(week.date());
            if (date == null) {
                return;
            }
            map.put(date, SyntaxHelper.calendarWeekSyntax(week, year));
        });
    }

    private static LocalDate dateOf(String value) {
        try {
            return LocalDate.parse(value);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public String serializeTsv(WeekCalendar weekCalendar) {
        Map<LocalDate, String> map = this.serializeMap(weekCalendar);
        return map.entrySet().stream().map(e -> (String)e.getValue() + "\t" + String.valueOf(e.getKey())).collect(Collectors.joining("\n"));
    }

    private Map<LocalDate, String> serializeMap(WeekCalendar weekCalendar) {
        TreeMap<LocalDate, String> dateWeekMap = new TreeMap<LocalDate, String>();
        weekCalendar.yearList().forEach(year -> WeekCalendarSerializer.serialize(year, dateWeekMap));
        return dateWeekMap;
    }
}

