/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.serializers;

import io.intino.magritte.framework.Layer;
import io.intino.sumus.model.AbstractReport;
import io.intino.sumus.model.Indicator;
import io.intino.sumus.model.Period;
import io.intino.sumus.model.PlotLine;
import io.intino.sumus.model.Range;
import io.intino.sumus.model.RangeBoundary;
import io.intino.sumus.model.Report;
import io.intino.sumus.model.Slice;
import io.intino.sumus.model.WeekCalendar;
import io.intino.sumus.reporting.model.Visibility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SyntaxHelper {
    public static String sliceSyntax(Slice slice) {
        return slice.attribute().name$() + ":" + (slice.isExcluded() ? "!" : "") + slice.value();
    }

    public static List<String> rangeSyntax(Range range) {
        ArrayList<String> list = new ArrayList<String>();
        if (range.from() != null && range.from().isBoundaryType()) {
            list.add(range.attribute().name$() + "-from:@" + SyntaxHelper.reactiveID(range.from().asBoundaryType()));
        }
        if (range.to() != null && range.to().isBoundaryType()) {
            list.add(range.attribute().name$() + "-to:@" + SyntaxHelper.reactiveID(range.to().asBoundaryType()));
        }
        return list;
    }

    public static String formatSyntax(Indicator indicator, String formatID) {
        return indicator.name$() + ":" + formatID;
    }

    public static String orderSyntax(Report.Insight.Ordered ordered) {
        return ordered.order().name() + (String)(ordered.orderBy() != null ? ":" + ordered.orderBy().name$() : "");
    }

    public static String barsSyntax(Report.TableBar tableBar) {
        return tableBar.bars().indicators().stream().map(Layer::name$).collect(Collectors.joining(","));
    }

    public static String attributesSyntax(Report.List list) {
        return list.itemList().stream().map(i -> i.attribute().name$()).collect(Collectors.joining(","));
    }

    public static String prefixesSyntax(Report.List list) {
        return list.itemList().stream().filter(i -> i.prefix() != null && !i.prefix().isEmpty()).map(i -> i.attribute().name$() + ":" + i.prefix()).collect(Collectors.joining(","));
    }

    public static String plotLinesSyntax(List<PlotLine> plotLines) {
        if (plotLines.isEmpty()) {
            return null;
        }
        return plotLines.stream().map(SyntaxHelper::plotLineSyntax).collect(Collectors.joining(","));
    }

    public static String plotLineSyntax(PlotLine plotLine) {
        return plotLine.value() + ":" + SyntaxHelper.valueOrDefault(plotLine.label(), "") + ":" + SyntaxHelper.valueOrDefault(plotLine.color(), "green");
    }

    public static String filterDimensionSyntax(Report.ViewCharts view) {
        if (view.selector() == null || view.selector().attribute() == null) {
            return "";
        }
        return view.selector().attribute().name$();
    }

    public static String rangeSyntax(Report.ViewCharts.Temporality temporality) {
        return SyntaxHelper.period(temporality.range(), temporality.rangeType());
    }

    public static String stepSyntax(Report.ViewCharts.Temporality temporality) {
        return SyntaxHelper.period(temporality.step());
    }

    public static String viewFiltersSyntax(Report.ViewCharts view) {
        if (!view.isFiltered() || view.asFiltered().sliceList().isEmpty()) {
            return null;
        }
        return view.asFiltered().sliceList().stream().map(SyntaxHelper::sliceSyntax).collect(Collectors.joining(","));
    }

    public static String calendarWeekSyntax(WeekCalendar.Year.Week week, WeekCalendar.Year year) {
        return year.year() + "|" + String.format("%02d", week.weekNumber());
    }

    public static Visibility visibilityOf(io.intino.sumus.model.rules.Visibility visibility) {
        if (visibility == null) {
            return Visibility.All;
        }
        return Arrays.stream(Visibility.values()).filter(v -> v.name().equalsIgnoreCase(visibility.name())).findFirst().orElse(Visibility.All);
    }

    public static String reactiveID(RangeBoundary.BoundaryType type) {
        RangeBoundary base = type.asRangeBoundary();
        if (base.isDate()) {
            return SyntaxHelper.reactiveID(base.asDate());
        }
        if (base.isRelative()) {
            return SyntaxHelper.reactiveID(base.asRelative());
        }
        return null;
    }

    public static String reactiveID(RangeBoundary.Date ref) {
        return "date#" + ref.day() + "#" + ref.month().getValue() + "#" + ref.year().name();
    }

    public static String reactiveID(RangeBoundary.Relative ref) {
        return "relative#" + ref.amount() + "#" + ref.scale().name();
    }

    private static String period(Period period, AbstractReport.AbstractViewCharts.AbstractTemporality.RangeType type) {
        return type == AbstractReport.AbstractViewCharts.AbstractTemporality.RangeType.Last && period.amount() == 1 ? period.unit().name() + ":last" : SyntaxHelper.period(period);
    }

    private static String period(Period period) {
        return period.amount() == 1 ? period.unit().name() : period.unit().name() + ":" + period.amount();
    }

    private static String valueOrDefault(String value, String _default) {
        return value != null ? value : _default;
    }
}

