/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.serializers;

import io.intino.alexandria.Json;
import io.intino.alexandria.logger.Logger;
import io.intino.magritte.builder.StashBuilder;
import io.intino.magritte.io.model.Stash;
import io.intino.sumus.archetype.Archetype;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.serializers.calendar.WeekCalendarSerializer;
import io.intino.sumus.box.serializers.dashboard.DashboardSerializer;
import io.intino.sumus.box.serializers.dashboard.ReportSerializer;
import io.intino.sumus.box.serializers.dictionary.DictionarySerializer;
import io.intino.sumus.box.serializers.ledger.LedgerSerializer;
import io.intino.sumus.box.serializers.storyboard.StoryboardSerializer;
import io.intino.sumus.box.util.ReactiveHelper;
import io.intino.sumus.model.Dashboard;
import io.intino.sumus.model.Dictionary;
import io.intino.sumus.model.Ledger;
import io.intino.sumus.model.RangeBoundary;
import io.intino.sumus.model.Report;
import io.intino.sumus.model.Storyboard;
import io.intino.sumus.model.SumusGraph;
import io.intino.sumus.model.Translatable;
import io.intino.sumus.model.WeekCalendar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

public class SumusSerializer {
    static final String TARA_EXTENSION = ".tara";
    private final SumusBox box;
    private final Archetype.Datamarts datamarts;

    public SumusSerializer(SumusBox box) {
        this.box = box;
        this.datamarts = box.archetype().datamarts();
    }

    public void serializeSearch(File directory) {
        try {
            this.serialize(SumusSerializer.findTaraFiles(directory));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public void serialize(List<File> taraFiles) throws IOException {
        Stash[] stashes = this.stashes(taraFiles);
        SumusGraph graph = SumusGraph.load(stashes);
        this.serialize(graph);
    }

    public void serialize(SumusGraph graph) {
        graph.ledgerList().forEach(this::serialize);
        graph.dashboardList().forEach(this::serializeAll);
        graph.storyboardList().forEach(this::serialize);
        graph.translatableList().forEach(this::serialize);
        this.update(graph.cubeRangeBoundaries());
        this.update(graph.weekCalendar());
    }

    private void serialize(Ledger ledger) {
        String json = Json.toJson((Object)new LedgerSerializer().serialize(ledger));
        SumusSerializer.save(json, this.datamarts.ledgers().getLedgerDefinition(ledger.id()));
    }

    private void serializeAll(Dashboard dashboard) {
        this.serialize(dashboard);
        dashboard.reportList().forEach(r -> this.serialize(dashboard, (Report)((Object)r)));
    }

    private void serialize(Dashboard dashboard) {
        String json = Json.toJson((Object)new DashboardSerializer(this.box).serialize(dashboard));
        SumusSerializer.save(json, this.datamarts.dashboards().getDashboardDefinition(dashboard.id()));
    }

    private void serialize(Dashboard dashboard, Report report) {
        String json = Json.toJson((Object)new ReportSerializer(this.box, dashboard).serialize(report));
        SumusSerializer.save(json, this.datamarts.dashboards().getDashboardReportDefinition(dashboard.id(), report.id()));
    }

    private void serialize(Storyboard storyboard) {
        String json = Json.toJson((Object)new StoryboardSerializer().serialize(storyboard));
        SumusSerializer.save(json, this.datamarts.storyboards().getStoryboardDefinition(storyboard.id()));
    }

    private void serialize(Translatable translatable) {
        translatable.dictionaries().forEach(dictionary -> {
            String json = Json.toJson(new DictionarySerializer().serialize((Dictionary)((Object)dictionary)));
            SumusSerializer.save(json, this.dictionaryFile(translatable, (Dictionary)((Object)dictionary)));
        });
    }

    private void update(List<RangeBoundary.BoundaryType> types) {
        String content = ReactiveHelper.serialize(types);
        SumusSerializer.save(content, this.box.archetype().datamarts().sumus().taraReactiveFunctions());
        this.box.reloadReactiveFunctions();
    }

    private void update(WeekCalendar weekCalendar) {
        if (weekCalendar == null) {
            return;
        }
        this.serialize(weekCalendar);
        this.box.reloadWeekCalendar();
    }

    private void serialize(WeekCalendar weekCalendar) {
        String tsv = new WeekCalendarSerializer().serializeTsv(weekCalendar);
        SumusSerializer.save(tsv, this.box.archetype().configuration().getCalendar());
    }

    private Stash[] stashes(List<File> files) throws IOException {
        try (PrintStream ps = new PrintStream(new FileOutputStream(this.taraLog(), true), true);){
            Stash[] stashArray = new StashBuilder(files, "Sumus", "3.0.0-SNAPSHOT", "", ps).build();
            return stashArray;
        }
    }

    private File dictionaryFile(Translatable translatable, Dictionary dictionary) {
        String extension = "." + dictionary.language() + ".json";
        if (translatable.i$(Ledger.class)) {
            return new File(this.datamarts.ledgers().root(), ((Ledger)translatable.a$(Ledger.class)).id() + extension);
        }
        if (translatable.i$(Dashboard.class)) {
            return new File(this.datamarts.dashboards().root(), ((Dashboard)translatable.a$(Dashboard.class)).id() + extension);
        }
        if (translatable.i$(Storyboard.class)) {
            return new File(this.datamarts.storyboards().root(), ((Storyboard)translatable.a$(Storyboard.class)).id() + extension);
        }
        return null;
    }

    private File taraLog() throws IOException {
        File log = this.datamarts.sumus().taraLog();
        log.createNewFile();
        return log;
    }

    private static void save(String content, File file) {
        try {
            Files.writeString(file.toPath(), (CharSequence)content, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Throwable e) {
            Logger.warn((String)("Unable to save " + file.getAbsolutePath()));
        }
    }

    private static List<File> findTaraFiles(File directory) {
        ArrayList<File> taraFiles = new ArrayList<File>();
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return taraFiles;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return taraFiles;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                taraFiles.addAll(SumusSerializer.findTaraFiles(file));
                continue;
            }
            if (!file.getName().toLowerCase().endsWith(TARA_EXTENSION)) continue;
            taraFiles.add(file);
        }
        return taraFiles;
    }
}

