/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.jmx;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.actions.BuildDashboardAction;
import io.intino.sumus.box.actions.BuildDashboardFromToAction;
import io.intino.sumus.box.actions.BuildReportAction;
import io.intino.sumus.box.actions.BuildReportFromToAction;
import io.intino.sumus.box.actions.SerializeTaraAction;
import io.intino.sumus.box.actions.SetThreadCountAction;
import io.intino.sumus.box.actions.ShowUpdatedLedgersAction;
import io.intino.sumus.box.actions.StartDashboardGeneratorAction;
import io.intino.sumus.box.actions.StopDashboardGeneratorAction;
import io.intino.sumus.box.jmx.MaintenanceToolsMBean;
import java.util.List;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

public class MaintenanceTools
extends StandardMBean
implements MaintenanceToolsMBean {
    private final SumusBox box;

    public MaintenanceTools(SumusBox box) throws NotCompliantMBeanException {
        super(MaintenanceToolsMBean.class);
        this.box = box;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this.getClass().getName(), "maintenanceTools", null, null, new MBeanOperationInfo[]{this.startDashboardGeneratorInfo(), this.stopDashboardGeneratorInfo(), this.showUpdatedLedgersInfo(), this.buildDashboardInfo(), this.buildDashboardFromToInfo(), this.buildReportInfo(), this.buildReportFromToInfo(), this.setThreadCountInfo(), this.serializeTaraInfo()}, null);
    }

    public MBeanOperationInfo startDashboardGeneratorInfo() {
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        return new MBeanOperationInfo("startDashboardGenerator", "Start auto generator", params, "", 1);
    }

    public MBeanOperationInfo stopDashboardGeneratorInfo() {
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        return new MBeanOperationInfo("stopDashboardGenerator", "Stop auto generator", params, "", 1);
    }

    public MBeanOperationInfo showUpdatedLedgersInfo() {
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        return new MBeanOperationInfo("showUpdatedLedgers", "Show last updated ledgers", params, "", 1);
    }

    public MBeanOperationInfo buildDashboardInfo() {
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("dashboard", "java.lang.String", ""), new MBeanParameterInfo("timetag", "java.lang.String", "")};
        return new MBeanOperationInfo("buildDashboard", "Build dashboard", params, "", 1);
    }

    public MBeanOperationInfo buildDashboardFromToInfo() {
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("dashboard", "java.lang.String", ""), new MBeanParameterInfo("fromTimetag", "java.lang.String", ""), new MBeanParameterInfo("toTimetag", "java.lang.String", "")};
        return new MBeanOperationInfo("buildDashboardFromTo", "Build dashboard from timetag to timetag", params, "", 1);
    }

    public MBeanOperationInfo buildReportInfo() {
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("dashboard", "java.lang.String", ""), new MBeanParameterInfo("report", "java.lang.String", ""), new MBeanParameterInfo("timetag", "java.lang.String", "")};
        return new MBeanOperationInfo("buildReport", "Build dashboard report", params, "", 1);
    }

    public MBeanOperationInfo buildReportFromToInfo() {
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("dashboard", "java.lang.String", ""), new MBeanParameterInfo("report", "java.lang.String", ""), new MBeanParameterInfo("fromTimetag", "java.lang.String", ""), new MBeanParameterInfo("toTimetag", "java.lang.String", "")};
        return new MBeanOperationInfo("buildReportFromTo", "Build dashboard report from timetag to timetag", params, "", 1);
    }

    public MBeanOperationInfo setThreadCountInfo() {
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("number", "java.lang.Integer", "")};
        return new MBeanOperationInfo("setThreadCount", "Set max number of threadpool threads", params, "", 1);
    }

    public MBeanOperationInfo serializeTaraInfo() {
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("files", "io.intino.alexandria.Resource", "")};
        return new MBeanOperationInfo("serializeTara", "Serialize tara definitions to json", params, "", 1);
    }

    @Override
    public String startDashboardGenerator() {
        try {
            StartDashboardGeneratorAction action = new StartDashboardGeneratorAction();
            action.box = this.box;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String stopDashboardGenerator() {
        try {
            StopDashboardGeneratorAction action = new StopDashboardGeneratorAction();
            action.box = this.box;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String showUpdatedLedgers() {
        try {
            ShowUpdatedLedgersAction action = new ShowUpdatedLedgersAction();
            action.box = this.box;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String buildDashboard(String dashboard, String timetag) {
        try {
            BuildDashboardAction action = new BuildDashboardAction();
            action.box = this.box;
            action.dashboard = dashboard;
            action.timetag = timetag;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String buildDashboardFromTo(String dashboard, String fromTimetag, String toTimetag) {
        try {
            BuildDashboardFromToAction action = new BuildDashboardFromToAction();
            action.box = this.box;
            action.dashboard = dashboard;
            action.fromTimetag = fromTimetag;
            action.toTimetag = toTimetag;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String buildReport(String dashboard, String report, String timetag) {
        try {
            BuildReportAction action = new BuildReportAction();
            action.box = this.box;
            action.dashboard = dashboard;
            action.report = report;
            action.timetag = timetag;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String buildReportFromTo(String dashboard, String report, String fromTimetag, String toTimetag) {
        try {
            BuildReportFromToAction action = new BuildReportFromToAction();
            action.box = this.box;
            action.dashboard = dashboard;
            action.report = report;
            action.fromTimetag = fromTimetag;
            action.toTimetag = toTimetag;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String setThreadCount(Integer number) {
        try {
            SetThreadCountAction action = new SetThreadCountAction();
            action.box = this.box;
            action.number = number;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String serializeTara(List<Resource> files) {
        try {
            SerializeTaraAction action = new SerializeTaraAction();
            action.box = this.box;
            action.files = files;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }
}

