/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.actions;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.watcher.LedgerWatcher;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.DashboardBuilder;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class UpdateDashboardAction {
    private static boolean isBuilding = false;
    public SumusBox box;

    public void execute() {
        LedgerWatcher watcher = this.box.watcher();
        if (watcher == null || watcher.isClosed() || isBuilding) {
            return;
        }
        isBuilding = true;
        try {
            Set<String> paths = watcher.updatedLedgers();
            this.buildReports(paths, this.box.dashboards());
            watcher.remove(paths);
        }
        catch (Throwable e) {
            Logger.error((String)"Error updating dashboards", (Throwable)e);
        }
        finally {
            isBuilding = false;
        }
    }

    private void buildReports(Set<String> paths, List<Dashboard> dashboards) {
        Map<String, Set<Timetag>> map = this.ledgerTimetagsMap(paths);
        dashboards.forEach(dashboard -> this.buildReports(map, (Dashboard)dashboard));
    }

    private void buildReports(Map<String, Set<Timetag>> map, Dashboard dashboard) {
        DashboardBuilder builder = this.box.dashboardBuilder(dashboard);
        dashboard.reports().forEach(report -> this.buildReport(builder, (Dashboard.Report)report, UpdateDashboardAction.timetagsToUpdate(map, report)));
    }

    private void buildReport(DashboardBuilder builder, Dashboard.Report report, Set<Timetag> timetags) {
        timetags.stream().sorted(Comparator.comparing(Timetag::datetime)).forEach(timetag -> this.buildReport(builder, report, (Timetag)timetag));
    }

    private void buildReport(DashboardBuilder builder, Dashboard.Report report, Timetag timetag) {
        try {
            if (report.isRealtime()) {
                builder.buildViews(report, timetag);
            } else {
                builder.build(report, timetag);
            }
        }
        catch (Throwable e) {
            Logger.error((String)("Unable to update dashboard report: " + report.name() + " - " + String.valueOf(timetag)), (Throwable)e);
        }
    }

    private static Set<Timetag> timetagsToUpdate(Map<String, Set<Timetag>> map, Dashboard.Report report) {
        return report.ledgers().stream().map(ledger -> map.getOrDefault(ledger, new HashSet())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Map<String, Set<Timetag>> ledgerTimetagsMap(Collection<String> paths) {
        HashMap<String, Set<Timetag>> map = new HashMap<String, Set<Timetag>>();
        paths.stream().map(File::new).filter(File::exists).forEach(file -> {
            String filename = file.getName();
            Timetag timetag = UpdateDashboardAction.timetagOf(filename.substring(0, filename.indexOf(".")));
            if (timetag == null) {
                return;
            }
            String ledger = file.getParentFile().getName();
            map.putIfAbsent(ledger, new HashSet());
            ((Set)map.get(ledger)).add(timetag);
        });
        return map;
    }

    private static Timetag timetagOf(String name) {
        try {
            LocalDate date = LocalDate.parse(name, DateTimeFormatter.ofPattern("yyyyMMdd"));
            return new Timetag(date, Scale.Day);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

