/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.actions;

import io.intino.alexandria.Context;
import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.serializers.SumusSerializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class SerializeTaraAction {
    public List<Resource> files;
    public SumusBox box;
    public Context context = new Context();

    public String execute() {
        try {
            File temp = Files.createTempDirectory("taraDefinitions", new FileAttribute[0]).toFile();
            this.execute(temp);
            this.removeRecursively(temp);
            return "Tara definitions serialized!";
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return "Error serializing tara definitions";
        }
    }

    private void execute(File temp) throws IOException {
        List<File> taraFiles = this.resourcesToFiles(temp);
        new SumusSerializer(this.box).serialize(taraFiles);
    }

    private List<File> resourcesToFiles(File root) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        for (Resource res : this.files) {
            File file = new File(root, res.name());
            Files.write(file.toPath(), res.readAllBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        return files;
    }

    private void removeRecursively(File dir) throws IOException {
        try (Stream<Path> stream = Files.walk(dir.toPath(), new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

