/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.actions;

import io.intino.alexandria.Context;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.util.Formatters;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.DashboardBuilder;
import io.intino.sumus.reporting.model.EmptyDashboard;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class BuildReportFromToAction {
    public SumusBox box;
    public Context context = new Context();
    public String fromTimetag;
    public String report;
    public String dashboard;
    public String toTimetag;

    public String execute() {
        Dashboard dashboard = this.box.dashboard(this.dashboard);
        if (dashboard instanceof EmptyDashboard) {
            return "Dashboard " + this.dashboard + " not found";
        }
        Dashboard.Report report = this.report(dashboard, this.report);
        if (report == null) {
            return "Report " + this.report + " not found";
        }
        if (Formatters.localDateOf(this.fromTimetag) == null) {
            return "Invalid from timetag " + this.fromTimetag;
        }
        if (Formatters.localDateOf(this.toTimetag) == null) {
            return "Invalid to timetag " + this.toTimetag;
        }
        new Thread(() -> {
            try {
                this.generateReports(dashboard, report);
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }).start();
        return "Report build launched from " + this.fromTimetag + " to" + this.toTimetag + ". See log for more details.";
    }

    private void generateReports(Dashboard dashboard, Dashboard.Report report) {
        Logger.info((String)"Jmx creating report..");
        DashboardBuilder builder = this.box.dashboardBuilder(dashboard);
        AtomicInteger count = new AtomicInteger(0);
        List<Timetag> timetags = this.timetags();
        timetags.forEach(timetag -> {
            count.incrementAndGet();
            builder.build(report, (Timetag)timetag);
            Logger.info((String)("Jmx report: " + report.name() + " of " + String.valueOf(timetag) + " created (" + count.get() + "/" + timetags.size() + ")"));
        });
        Logger.info((String)("Jmx reports from " + this.fromTimetag + " to " + this.toTimetag + " created! (" + count.get() + ")"));
    }

    private List<Timetag> timetags() {
        ArrayList<Timetag> timetags = new ArrayList<Timetag>();
        Timetag.of((String)this.fromTimetag).iterateTo(Timetag.of((String)this.toTimetag)).forEach(timetags::add);
        return timetags;
    }

    private Dashboard.Report report(Dashboard dashboard, String name) {
        if (name == null) {
            return null;
        }
        String reportName = name.trim().replace("-", " ");
        return dashboard.report(reportName);
    }
}

