/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.actions;

import io.intino.alexandria.Context;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.util.Formatters;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.DashboardBuilder;
import io.intino.sumus.reporting.model.EmptyDashboard;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class BuildDashboardFromToAction {
    public SumusBox box;
    public Context context = new Context();
    public String fromTimetag;
    public String dashboard;
    public String toTimetag;

    public String execute() {
        Dashboard dashboard = this.box.dashboard(this.dashboard);
        if (dashboard instanceof EmptyDashboard) {
            return "Dashboard " + this.dashboard + " not found";
        }
        if (Formatters.localDateOf(this.fromTimetag) == null) {
            return "Invalid from timetag " + this.fromTimetag;
        }
        if (Formatters.localDateOf(this.toTimetag) == null) {
            return "Invalid to timetag " + this.toTimetag;
        }
        new Thread(() -> {
            try {
                this.buildDashboard(dashboard);
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }).start();
        return "Dashboard generator launched. See log for more details.";
    }

    private void buildDashboard(Dashboard dashboard) {
        Logger.info((String)("Jmx creating dashboard from " + this.fromTimetag + " to " + this.toTimetag + ".."));
        DashboardBuilder builder = this.box.dashboardBuilder(dashboard);
        AtomicInteger count = new AtomicInteger();
        List<Timetag> timetags = this.timetags();
        timetags.forEach(timetag -> {
            Logger.info((String)("Creating dashboard " + dashboard.name() + " of " + String.valueOf(timetag) + " (" + count.incrementAndGet() + "/" + timetags.size() + ")..."));
            builder.build((Timetag)timetag);
        });
        Logger.info((String)("Jmx dashboard " + dashboard.name() + " from " + this.fromTimetag + " to " + this.toTimetag + " created! (" + timetags.size() + ")"));
    }

    private List<Timetag> timetags() {
        ArrayList<Timetag> timetags = new ArrayList<Timetag>();
        new Timetag(this.fromTimetag).iterateTo(new Timetag(this.toTimetag)).forEach(timetags::add);
        return timetags;
    }
}

