/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.auth.Space;
import io.intino.amidas.accessor.alexandria.core.AmidasOauthAccessor;
import io.intino.sumus.box.AbstractBox;
import io.intino.sumus.box.RealtimeBuilder;
import io.intino.sumus.box.SumusArchetype;
import io.intino.sumus.box.SumusConfiguration;
import io.intino.sumus.box.actions.SetThreadCountAction;
import io.intino.sumus.box.ui.Theme;
import io.intino.sumus.box.ui.datasources.Range;
import io.intino.sumus.box.util.DataFormatter;
import io.intino.sumus.box.util.NodeRealtimeBuilder;
import io.intino.sumus.box.util.ReactiveHelper;
import io.intino.sumus.box.watcher.LedgerWatcher;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.model.LedgerDefinition;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.DashboardBuilder;
import io.intino.sumus.reporting.ReactiveFunction;
import io.intino.sumus.reporting.ReactiveFunctions;
import io.intino.sumus.reporting.Storyboard;
import io.intino.sumus.reporting.calendars.CustomWeekCalendar;
import io.intino.sumus.reporting.loaders.LedgerLoader;
import io.intino.sumus.reporting.model.Scale;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SumusBox
extends AbstractBox {
    public static final String Dsl = "Sumus";
    public static final String DslVersion = "3.0.0-SNAPSHOT";
    static final String TsvExtension = ".tsv";
    private final SumusArchetype archetype;
    private final LedgerLoader ledgerLoader;
    private final RealtimeBuilder realTimeBuilder;
    private final LedgerWatcher watcher;
    private final DataFormatter dataFormatter;
    private final Map<String, String> labelLedgers = new TreeMap<String, String>();
    private List<String> masterLedgers;

    public SumusBox(String[] args) {
        this(new SumusConfiguration(args));
    }

    public SumusBox(SumusConfiguration configuration) {
        super(configuration);
        this.archetype = new SumusArchetype(configuration.home());
        this.ledgerLoader = new LedgerLoader(this.archetype.datamarts().ledgers().root());
        this.watcher = new LedgerWatcher(this);
        this.realTimeBuilder = new NodeRealtimeBuilder(this);
        this.dataFormatter = new DataFormatter().decimals(this.micrositeDecimals());
    }

    public SumusArchetype archetype() {
        return this.archetype;
    }

    public RealtimeBuilder realtimeBuilder() {
        return this.realTimeBuilder;
    }

    public LedgerWatcher watcher() {
        return this.watcher;
    }

    public DataFormatter dataFormatter() {
        return this.dataFormatter;
    }

    public DashboardBuilder dashboardBuilder(Dashboard dashboard) {
        return new DashboardBuilder(dashboard, this.archetype.datamarts().dashboards().root()).minify(this.minifyHtml());
    }

    @Override
    public void beforeStart() {
        this.reloadWeekCalendar();
        this.setThreadCount();
        this.reloadReactiveFunctions();
    }

    @Override
    public void afterStart() {
        if (this.watcherAutoStart()) {
            this.startWatcher();
        }
        this.loadPendingLedgers();
    }

    @Override
    public void beforeStop() {
        this.stopWatcher();
        this.savePendingLedgers();
    }

    @Override
    public void afterStop() {
    }

    @Override
    public Box put(Object o) {
        super.put(o);
        return this;
    }

    @Override
    protected AuthService authService(URL authServiceUrl) {
        try {
            if (authServiceUrl == null) {
                return null;
            }
            return new AmidasOauthAccessor(new Space(new URL(this.configuration().url())), authServiceUrl);
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public List<String> ledgers() {
        return this.archetype.ledgers().stream().filter(l -> !this.isMaster((String)l)).sorted().collect(Collectors.toList());
    }

    public List<String> dashboardNames() {
        return this.archetype.dashboardNames();
    }

    public List<String> storyboardNames() {
        return this.archetype.storyboardNames();
    }

    public List<String> reportNames(String dashboard) {
        return this.archetype.reportNames(dashboard);
    }

    public List<Dashboard> dashboards() {
        return this.archetype.dashboards();
    }

    public Dashboard dashboard(String dashboard) {
        return this.archetype.dashboard(dashboard);
    }

    public Storyboard storyboard(String storyboard) {
        return this.archetype.storyboard(storyboard);
    }

    public LedgerDefinition ledgerDefinition(String ledger) {
        return this.archetype.ledgerDefinition(ledger);
    }

    public String reportNode(String dashboard, String report, Timetag period, Scale scale, String window, String node) {
        return this.archetype.reportNode(dashboard, report, period, scale, window, node);
    }

    public String singletonReportNode(String dashboard, String report, String node) {
        return this.archetype.singletonReportNode(dashboard, report, node);
    }

    public String viewNode(String dashboard, String view, Timetag period, String node) {
        return this.archetype.viewNode(dashboard, view, period, node);
    }

    public String defaultReportNodeName(String dashboard, String report, Timetag period, Scale scale, String window) {
        return this.archetype.defaultReportNodeName(dashboard, report, period, scale, window);
    }

    public Map<String, String> ledgerTranslations(String ledger, String language) {
        return this.archetype.ledgerTranslations(ledger, language);
    }

    public Map<String, String> dashboardTranslations(String dashboard, String language) {
        return this.archetype.dashboardTranslations(dashboard, language);
    }

    public Map<String, String> storyboardTranslations(String storyboard, String language) {
        return this.archetype.storyboardTranslations(storyboard, language);
    }

    public Ledger ledger(String ledger, Timetag period) {
        return this.ledgerLoader.ledger(ledger, period);
    }

    public Range ledgerRange(String ledger) {
        String name = SumusBox.baseLedger(ledger, this.ledgerDefinition(ledger));
        List files = this.archetype.datamarts().ledgers().getLedgerFiles(name);
        File first = files.stream().min(Comparator.comparing(File::getName)).orElse(null);
        File last = files.stream().max(Comparator.comparing(File::getName)).orElse(null);
        Range result = new Range();
        if (first != null) {
            result.min = Timetag.of((String)first.getName().replace(TsvExtension, ""));
        }
        if (last != null) {
            result.max = Timetag.of((String)last.getName().replace(TsvExtension, ""));
        }
        return result;
    }

    public List<File> reportFiles(String dashboard, String report) {
        return this.archetype.datamarts().dashboards().getDashboardPeriods(dashboard, report);
    }

    public Map<String, String> labelLedgerMap() {
        this.ledgers().stream().filter(l -> !this.labelLedgers.containsValue(l)).forEach(ledger -> {
            LedgerDefinition definition = this.ledgerDefinition((String)ledger);
            String label = definition != null && definition.label != null ? definition.label : ledger;
            this.labelLedgers.put(label, (String)ledger);
        });
        return this.labelLedgers;
    }

    public URL logoUrl() {
        try {
            String logo = this.configuration().logo();
            File logoFile = logo != null && !logo.isEmpty() ? new File(logo) : this.archetype().configuration().getLogo();
            return logoFile.exists() ? logoFile.toURI().toURL() : SumusBox.class.getResource("/logo.png");
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public String logoContent() {
        return this.archetype.logoContent();
    }

    public Theme theme() {
        return this.archetype.theme();
    }

    private boolean watcherAutoStart() {
        try {
            return Boolean.parseBoolean(this.configuration.autostartWatcher());
        }
        catch (Throwable e) {
            return false;
        }
    }

    public boolean startWatcher() {
        try {
            this.watcher.start();
            Logger.info((String)"Ledger watcher started");
            return true;
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    public boolean stopWatcher() {
        try {
            this.watcher.stop();
            Logger.info((String)"Ledger watcher stopped");
            return true;
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    public void loadPendingLedgers() {
        File file = this.archetype.datamarts().sumus().pendingLedgers();
        if (!file.exists()) {
            return;
        }
        try {
            List<String> ledgers = Files.readAllLines(file.toPath()).stream().filter(Objects::nonNull).filter(l -> !l.isEmpty()).collect(Collectors.toList());
            this.watcher.updatedLedgers(ledgers);
        }
        catch (Throwable e) {
            Logger.warn((String)"Unable to load pending ledgers");
        }
    }

    public void savePendingLedgers() {
        try {
            File file = this.archetype.datamarts().sumus().pendingLedgers();
            String content = String.join((CharSequence)"\n", this.watcher.updatedLedgers());
            Files.write(file.toPath(), content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Throwable e) {
            Logger.warn((String)"Unable to save pending ledgers");
        }
    }

    private void setThreadCount() {
        String threads = this.configuration.threadCount();
        if (threads == null || threads.trim().isEmpty()) {
            return;
        }
        SetThreadCountAction action = new SetThreadCountAction();
        action.box = this;
        action.number = Integer.parseInt(threads);
        action.execute();
    }

    public void reloadWeekCalendar() {
        File file = this.archetype.configuration().getCalendar();
        if (file.exists()) {
            Scale.WeekCalendar = new CustomWeekCalendar(file);
            Logger.info((String)"Using custom week calendar!");
        }
    }

    public void reloadReactiveFunctions() {
        List files = this.archetype.datamarts().sumus().getReactivesFunctions();
        List<ReactiveFunction> functions = ReactiveHelper.deserialize(files);
        functions.forEach(f -> ReactiveFunctions.add(f.id(), f::function));
        if (!functions.isEmpty()) {
            Logger.info((String)("Loaded " + functions.size() + " reactive functions"));
        }
    }

    private boolean minifyHtml() {
        try {
            return Boolean.parseBoolean(this.configuration.minifyHtml());
        }
        catch (Throwable e) {
            return false;
        }
    }

    private int micrositeDecimals() {
        try {
            return Integer.parseInt(this.configuration.micrositeDecimals());
        }
        catch (Throwable e) {
            return -1;
        }
    }

    private List<String> masterLedgers() {
        if (this.masterLedgers == null) {
            this.masterLedgers = this.archetype.ledgers().stream().filter(l -> SumusBox.isMaster(this.ledgerDefinition((String)l))).collect(Collectors.toList());
        }
        return this.masterLedgers;
    }

    protected boolean isMaster(String ledger) {
        return this.masterLedgers().contains(ledger);
    }

    protected static boolean isMaster(LedgerDefinition definition) {
        return definition != null && definition.content == LedgerDefinition.Content.Master;
    }

    protected static String baseLedger(String ledger, LedgerDefinition definition) {
        return definition != null && definition.aggregation != null && definition.aggregation.ledger != null ? definition.aggregation.ledger : ledger;
    }
}

