/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box;

import com.google.gson.Gson;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zip.Zip;
import io.intino.sumus.archetype.Archetype;
import io.intino.sumus.box.ui.Theme;
import io.intino.sumus.box.util.Formatters;
import io.intino.sumus.engine.model.LedgerDefinition;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Storyboard;
import io.intino.sumus.reporting.model.DashboardDefinition;
import io.intino.sumus.reporting.model.EmptyDashboard;
import io.intino.sumus.reporting.model.Scale;
import io.intino.sumus.reporting.model.StoryboardDefinition;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spark.utils.IOUtils;

public class SumusArchetype
extends Archetype {
    static final String LedgerExtension = ".ledger";
    static final String DashboardExtension = ".dashboard";
    static final String StoryboardExtension = ".storyboard";
    static final String HtmlExtension = ".html";
    static final String JsonExtension = ".json";
    static final String TaraExtension = ".tara";
    static final String All = "_All";

    public SumusArchetype(File root) {
        super(root);
    }

    public List<String> ledgers() {
        return this.datamarts().ledgers().getLedgerDefinitions().stream().filter(c -> c.getName().endsWith(LedgerExtension)).map(f -> f.getName().replace(LedgerExtension, "")).collect(Collectors.toList());
    }

    public List<String> dashboardNames() {
        return this.datamarts().dashboards().getDashboardDefinitions().stream().filter(c -> c.getName().endsWith(DashboardExtension)).map(f -> f.getName().replace(DashboardExtension, "")).sorted().collect(Collectors.toList());
    }

    public List<String> storyboardNames() {
        return this.datamarts().storyboards().getStoryboardDefinitions().stream().filter(c -> c.getName().endsWith(StoryboardExtension)).map(f -> f.getName().replace(StoryboardExtension, "")).sorted().collect(Collectors.toList());
    }

    public List<String> reportNames(String dashboard) {
        File[] files = this.datamarts().dashboards().getDashboardReports(dashboard).listFiles();
        if (files == null) {
            return new ArrayList<String>();
        }
        return Arrays.stream(files).filter(File::isDirectory).map(File::getName).collect(Collectors.toList());
    }

    public LedgerDefinition ledgerDefinition(String ledger) {
        try {
            File file = this.datamarts().ledgers().getLedgerDefinition(ledger);
            return LedgerDefinition.load((File)file.getParentFile(), (File)file);
        }
        catch (Throwable e) {
            Logger.warn((String)("Error loading ledger definition: " + ledger));
            return null;
        }
    }

    public List<Dashboard> dashboards() {
        return this.datamarts().dashboards().getDashboardDefinitions().stream().map(this::dashboard).filter(d -> !(d instanceof EmptyDashboard)).collect(Collectors.toList());
    }

    public Dashboard dashboard(String name) {
        return this.dashboard(this.datamarts().dashboards().getDashboardDefinition(name));
    }

    private Dashboard dashboard(File file) {
        try {
            return file.exists() ? DashboardDefinition.fromJson(SumusArchetype.contentOf(file)) : new EmptyDashboard();
        }
        catch (Throwable e) {
            Logger.error((String)("Error parsing " + file.getName()), (Throwable)e);
            return new EmptyDashboard();
        }
    }

    public Storyboard storyboard(String name) {
        try {
            File file = this.datamarts().storyboards().getStoryboardDefinition(name);
            return file.exists() ? StoryboardDefinition.load(SumusArchetype.contentOf(file)) : new StoryboardDefinition();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return new StoryboardDefinition();
        }
    }

    public Map<String, String> ledgerTranslations(String ledger, String language) {
        return this.translations(this.datamarts().ledgers().getLedgerTranslations(ledger, language));
    }

    public Map<String, String> dashboardTranslations(String dashboard, String language) {
        return this.translations(this.datamarts().dashboards().getDashboardTranslations(dashboard, language));
    }

    public Map<String, String> storyboardTranslations(String storyboardKey, String language) {
        File file = this.datamarts().storyboards().getStoryboardTranslations(storyboardKey, language);
        if (!file.exists()) {
            file = this.datamarts().storyboards().getStoryboardTranslations(storyboardKey.split("-")[0], language);
        }
        return this.translations(file);
    }

    private Map<String, String> translations(File file) {
        try {
            return file.exists() ? (Map)new Gson().fromJson(SumusArchetype.contentOf(file), Map.class) : new HashMap<String, String>();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return Collections.emptyMap();
        }
    }

    public String reportNode(String dashboard, String report, Timetag period, Scale scale, String window, String node) {
        try {
            File zipFile;
            if (period == null) {
                return null;
            }
            String timetag = scale.timetag(period.datetime().toLocalDate());
            File file = zipFile = SumusArchetype.useWindow(window) ? this.datamarts().dashboards().getDashboardReport(dashboard, report, timetag, window) : this.datamarts().dashboards().getDashboardReport(dashboard, report, timetag);
            if (!zipFile.exists()) {
                return null;
            }
            return SumusArchetype.zipContent(zipFile, timetag + (String)(window != null ? "#" + window : "") + "/" + node + HtmlExtension);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public String singletonReportNode(String dashboard, String report, String node) {
        try {
            File zipFile = this.datamarts().dashboards().getDashboardReport(dashboard, report, report);
            if (!zipFile.exists()) {
                return null;
            }
            return SumusArchetype.zipContent(zipFile, report + "/" + node + HtmlExtension);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public String defaultReportNodeName(String dashboard, String report, Timetag period, Scale scale, String window) {
        try {
            File zipFile;
            if (period == null) {
                return All;
            }
            String timetag = scale.timetag(period.datetime().toLocalDate());
            File file = zipFile = SumusArchetype.useWindow(window) ? this.datamarts().dashboards().getDashboardReport(dashboard, report, timetag, window) : this.datamarts().dashboards().getDashboardReport(dashboard, report, timetag);
            if (!zipFile.exists()) {
                return All;
            }
            Zip zip = new Zip(zipFile);
            return zip.entries().isEmpty() ? All : ((String)zip.entries().get(0)).split("/")[1].replace(HtmlExtension, "");
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return All;
        }
    }

    public String viewNode(String dashboard, String view, Timetag period, String node) {
        try {
            if (period == null) {
                return null;
            }
            File zipFile = this.datamarts().dashboards().getDashboardView(dashboard, view, period.value());
            if (!zipFile.exists()) {
                return null;
            }
            return SumusArchetype.zipContent(zipFile, period.value() + "/" + node + JsonExtension);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public String logoContent() {
        String string;
        block9: {
            File file = this.configuration().getLogoBase64();
            if (file.exists()) {
                return SumusArchetype.contentOf(file);
            }
            InputStream stream = Formatters.class.getResourceAsStream("/logo.base64.txt");
            try {
                string = new String(IOUtils.toByteArray((InputStream)stream));
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    Logger.error((Throwable)e);
                    return null;
                }
            }
            stream.close();
        }
        return string;
    }

    public Theme theme() {
        try {
            File file = this.configuration().getTheme();
            if (!file.exists()) {
                return new Theme();
            }
            Theme theme = new Theme();
            theme.putAll((Map)new Gson().fromJson(SumusArchetype.contentOf(file), Map.class));
            return theme;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return new Theme();
        }
    }

    public File dashboardTemplateFile(String dashboard, String template) {
        return new File(this.datamarts().dashboards().root(), dashboard + "/templates/" + template + HtmlExtension);
    }

    public static List<File> taraFiles(File folder) {
        List<File> list;
        block8: {
            Stream<Path> walk = Files.walk(folder.toPath(), new FileVisitOption[0]);
            try {
                list = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(TaraExtension)).map(Path::toFile).collect(Collectors.toList());
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    return List.of();
                }
            }
            walk.close();
        }
        return list;
    }

    private static String contentOf(File file) throws IOException {
        return Files.readString(file.toPath());
    }

    private static String zipContent(File zipFile, String filePath) throws IOException {
        return new Zip(zipFile).read(filePath);
    }

    private static boolean useWindow(String window) {
        return window != null && Integer.parseInt(window) != 1;
    }
}

