/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.AlexandriaSparkBuilder;
import io.intino.alexandria.jmx.JMXServer;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.UISpark;
import io.intino.alexandria.ui.UiElementsService;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.TranslatorService;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.sumus.box.I18n;
import io.intino.sumus.box.JMXMaintenanceTools;
import io.intino.sumus.box.Sentinels;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.SumusConfiguration;
import io.intino.sumus.box.ui.SumusElementsService;
import io.intino.sumus.box.ui.displays.RouteDispatcher;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends AlexandriaUiBox {
    protected SumusConfiguration configuration;
    protected JMXServer maintenanceTools;
    private AlexandriaScheduler scheduler = new AlexandriaScheduler();
    protected Map<String, Soul> uiSouls = new HashMap<String, Soul>();
    private List<AlexandriaUiBox.SoulsClosed> soulsClosedListeners = new ArrayList<AlexandriaUiBox.SoulsClosed>();
    private AuthService authService;
    private PushService pushService;

    public AbstractBox(String[] args) {
        this(new SumusConfiguration(args));
    }

    public AbstractBox(SumusConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
    }

    public SumusConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        return this;
    }

    public abstract void beforeStart();

    public Box start() {
        this.initConnector();
        if (this.owner != null) {
            this.owner.beforeStart();
        }
        this.beforeStart();
        if (this.owner != null) {
            this.owner.startServices();
        }
        this.startServices();
        if (this.owner != null) {
            this.owner.afterStart();
        }
        this.afterStart();
        return this;
    }

    public abstract void afterStart();

    public abstract void beforeStop();

    public void stop() {
        if (this.owner != null) {
            this.owner.beforeStop();
        }
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stopServices();
        }
        this.stopServices();
        if (this.owner != null) {
            this.owner.afterStop();
        }
        this.afterStop();
    }

    public void stopServices() {
        AlexandriaSparkBuilder.instance().stop();
    }

    public abstract void afterStop();

    public void startServices() {
        this.initUI();
        this.initAgenda();
        this.initRestServices();
        this.initSoapServices();
        this.initJmxServices();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
        this.initCli();
    }

    public PushService pushService() {
        return this.pushService;
    }

    public List<Soul> souls() {
        return new ArrayList<Soul>(this.uiSouls.values());
    }

    public Optional<Soul> soul(String clientId) {
        return Optional.ofNullable(this.uiSouls.get(clientId));
    }

    public void registerSoul(String clientId, Soul soul) {
        this.uiSouls.put(clientId, soul);
    }

    public void unRegisterSoul(String clientId) {
        this.uiSouls.remove(clientId);
        if (this.uiSouls.size() <= 0) {
            this.notifySoulsClosed();
        }
    }

    public void onSoulsClosed(AlexandriaUiBox.SoulsClosed listener) {
        this.soulsClosedListeners.add(listener);
    }

    private void notifySoulsClosed() {
        this.soulsClosedListeners.forEach(l -> l.accept());
    }

    protected abstract AuthService authService(URL var1);

    public AlexandriaScheduler scheduler() {
        return this.scheduler;
    }

    protected void beforeSetupSumusElementsUi(UISpark sparkInstance) {
    }

    public void setupSumusElementsUi() {
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        this.authService = this.authService(AbstractBox.url(this.configuration().get("federation_url")));
        AlexandriaSparkBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/");
        AlexandriaSparkBuilder.setUI((boolean)true);
        AlexandriaSparkBuilder.addParameters((Object[])new Object[]{this.authService});
        this.pushService = new PushService();
        UISpark sparkInstance = (UISpark)AlexandriaSparkBuilder.instance();
        this.beforeSetupSumusElementsUi(sparkInstance);
        SumusElementsService.init(sparkInstance, (SumusBox)this, this.pushService, new RouteDispatcher());
        UiElementsService.initDisplays((UISpark)sparkInstance, (PushService)this.pushService);
    }

    private void initRestServices() {
    }

    private void initSoapServices() {
    }

    private void initMessagingServices() {
    }

    private void initJmxServices() {
        this.maintenanceTools = new JMXMaintenanceTools().init((Box)((SumusBox)this));
        io.intino.alexandria.logger.Logger.info((String)"Jmx service maintenanceTools: started!");
    }

    private void initSlackBots() {
    }

    private void initUI() {
        this.setupSumusElementsUi();
        this.initTranslatorService();
        UISpark sparkSumusElementsInstance = (UISpark)AlexandriaSparkBuilder.instance();
        sparkSumusElementsInstance.start();
        io.intino.alexandria.logger.Logger.info((String)("UI SumusElements: started at port " + this.configuration().get("port") + "!"));
    }

    private void initTranslatorService() {
        this.translatorService = new TranslatorService();
        this.translatorService.addAll(I18n.dictionaries());
        this.translatorService.addAll(io.intino.alexandria.I18n.dictionaries());
    }

    protected void initConnector() {
    }

    protected void initTerminal() {
    }

    protected void initSentinels() {
        Sentinels.init(this.scheduler, this.configuration.home(), (SumusBox)this);
    }

    protected void initWorkflow() {
    }

    protected void initAgenda() {
    }

    protected void initCli() {
    }

    protected void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new io.intino.alexandria.logger.Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
        io.intino.alexandria.logger4j.Logger.init();
    }

    public static URL url(String url) {
        try {
            return new URI(url).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            return null;
        }
    }
}

