import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenSite from "alexandria-ui-elements/src/displays/components/OpenSite";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import DisplaysStoryboardStepTemplate from "sumus-elements/gen/displays/templates/StoryboardStepTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import StoryboardTemplateNotifier from "sumus-elements/gen/displays/notifiers/StoryboardTemplateNotifier";
import StoryboardTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class StoryboardTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new StoryboardTemplateNotifier(this);
		this.requester = new StoryboardTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_673971421" format="airBottom h3" visible={false} mode="normal">
				</UiText>
				<UiOpenSite context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2054925318" title="" target="blank" mode="Link" size="Medium">
				</UiOpenSite>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_363535180" format="bordered middleAirBottom spaced" layout="vertical">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_363535180.a_230716292" format="h6" mode="normal" translate={true} value="What do you want to see?">
					</UiText>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_363535180.a_1289579275" layout="vertical" width="300px" height="-1px">
						<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_363535180.a_1289579275.a_338855054" multipleSelection={false} maxMenuHeight={300}>
						</UiSelectorComboBox>
					</UiBlock>
				</UiBlock>
				<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_674581518" multiple={{instances:"steps",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
				</UiMultiple>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
		if (!this.props.onProxyMessage) return;
		this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(StoryboardTemplate));
DisplayFactory.register("StoryboardTemplate", withStyles(styles, { withTheme: true })(withSnackbar(StoryboardTemplate)));