/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.resources;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.DisplayRepository;
import io.intino.alexandria.ui.displays.DisplayRouter;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.spark.UISparkManager;
import io.intino.alexandria.ui.spark.pages.UiPage;
import io.intino.alexandria.ui.spark.resources.Resource;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.displays.RouteDispatcher;
import io.intino.sumus.box.ui.pages.ReportPage;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class ReportResource
extends Resource {
    private final SumusBox box;

    public ReportResource(SumusBox box, UISparkManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
        this.box = box;
    }

    public void execute() throws AlexandriaException {
        super.execute();
        this.fillDeviceParameter();
        if (this.isLogged()) {
            this.render();
        } else {
            this.authenticate();
        }
    }

    private void render() {
        String clientId = UUID.randomUUID().toString();
        ReportPage page = new ReportPage();
        ((UiPage)page).session = this.manager.currentSession();
        ((UiPage)page).session.browser().onRedirect(location -> this.manager.redirect(location));
        ((UiPage)page).session.browser().requestUrl(this.manager.requestUrl());
        ((UiPage)page).session.whenLogin((Function)new Function<String, String>(){
            final /* synthetic */ UiPage val$page;
            {
                this.val$page = uiPage;
            }

            @Override
            public String apply(String baseUrl) {
                return ReportResource.this.authenticate(this.val$page.session, baseUrl);
            }
        });
        ((UiPage)page).session.whenLogout(arg_0 -> this.lambda$render$1((UiPage)page, arg_0));
        page.box = this.box;
        ((UiPage)page).clientId = clientId;
        ((UiPage)page).device = this.parameterValue("device");
        ((UiPage)page).token = this.parameterValue("token");
        page.dashboard = this.parameterValue("dashboard");
        page.report = this.parameterValue("report");
        page.period = this.parameterValue("period");
        page.node = this.parameterValue("node");
        if (!page.hasPermissions()) {
            this.manager.redirect(page.redirectUrl());
            return;
        }
        ((PushService)this.manager.pushService()).onOpen(arg_0 -> this.lambda$render$5((UiPage)page, clientId, arg_0));
        ((PushService)this.manager.pushService()).onClose(clientId).execute((Consumer)new Consumer<UIClient>(){

            @Override
            public void accept(UIClient client) {
                ReportResource.this.box.soul(client.id()).ifPresent(s -> s.destroy());
                ReportResource.this.box.unRegisterSoul(client.id());
                ReportResource.this.manager.unRegister(client);
            }
        });
        this.manager.write((Object)page.execute());
    }

    private /* synthetic */ Boolean lambda$render$5(UiPage page, String clientId, UIClient client) {
        if (!client.id().equals(page.clientId)) {
            return false;
        }
        if (client.soul() != null) {
            ((RouteDispatcher)this.box.routeManager().routeDispatcher()).dispatchReport(client.soul(), ((ReportPage)page).dashboard, ((ReportPage)page).report, ((ReportPage)page).period, ((ReportPage)page).node);
            return false;
        }
        Soul soul = page.prepareSoul(client);
        soul.onRedirect(location -> this.manager.redirect(location));
        soul.addRegisterDisplayListener(display -> {
            display.inject(this.notifier(page.session, client, (Display)display));
            display.inject(page.session);
            display.inject((DisplayRepository)soul);
            display.inject(() -> soul);
        });
        client.soul(soul);
        client.cookies(this.manager.cookies());
        this.box.registerSoul(clientId, soul);
        soul.register(new DisplayRouter((AlexandriaUiBox)this.box).id("__router__"));
        ((RouteDispatcher)this.box.routeManager().routeDispatcher()).dispatchReport(soul, ((ReportPage)page).dashboard, ((ReportPage)page).report, ((ReportPage)page).period, ((ReportPage)page).node);
        return true;
    }

    private /* synthetic */ void lambda$render$1(UiPage page, Boolean b) {
        this.logout(page.session);
    }
}

