/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.schemas.CubeBarChartInfo;
import io.intino.sumus.box.ui.datasources.CubeDatasource;
import io.intino.sumus.box.ui.displays.CubeBarChart;
import io.intino.sumus.box.ui.displays.templates.AbstractStoryboardStepTemplate;
import io.intino.sumus.box.ui.displays.templates.CategoryTag;
import io.intino.sumus.engine.Dimension;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StoryboardStepTemplate
extends AbstractStoryboardStepTemplate<SumusBox> {
    private CubeDatasource source;
    private String indicator;
    private List<Dimension> dimensions;
    private Dimension dimension;
    private List<String> categories;
    private Consumer<Dimension> selectListener;
    private BiConsumer<Dimension, List<String>> showDetailsListener;
    private BiConsumer<Dimension, List<String>> filterListener;
    private Function<String, String> indicatorLabelProvider;
    private Function<String, String> dimensionLabelProvider;
    private int zoomLevel = 1;
    private boolean readonly = false;

    public StoryboardStepTemplate(Box box) {
        super((SumusBox)box);
    }

    public void source(CubeDatasource source) {
        this.source = source;
    }

    public void indicatorLabelProvider(Function<String, String> indicatorLabelProvider) {
        this.indicatorLabelProvider = indicatorLabelProvider;
    }

    public void indicator(String indicator) {
        this.indicator = indicator;
    }

    public void dimensionLabelProvider(Function<String, String> dimensionLabelProvider) {
        this.dimensionLabelProvider = dimensionLabelProvider;
    }

    public void dimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
    }

    public void dimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public void categories(List<String> categories) {
        this.categories = categories;
    }

    public void onSelect(Consumer<Dimension> listener) {
        this.selectListener = listener;
    }

    public void onShowDetails(BiConsumer<Dimension, List<String>> listener) {
        this.showDetailsListener = listener;
    }

    public void onFilter(BiConsumer<Dimension, List<String>> listener) {
        this.filterListener = listener;
    }

    public void readonly(boolean value) {
        this.readonly = value;
    }

    @Override
    public void init() {
        super.init();
        this.initSummary();
        this.dimensionSelectorBlock.onInit(e -> this.initDimensionSelectorBlock());
        this.dimensionSelectorBlock.onShow(e -> this.refreshDimensionSelectorBlock());
        this.categoriesSelectorBlock.onInit(e -> this.initCategoriesSelectorBlock());
        this.categoriesSelectorBlock.onShow(e -> this.refreshCategoriesSelectorBlock());
    }

    public void refresh() {
        super.refresh();
        this.refreshSummary();
        this.refreshBlocks();
    }

    private void initSummary() {
        this.dimensionLink.onExecute(e -> this.updateDimension((Dimension)null));
        this.detailsLink.onExecute(e -> this.showDetails());
        this.editAction.onExecute(e -> this.showCategoriesBlock());
        this.continueAction.onExecute(e -> this.filter());
    }

    private void refreshSummary() {
        this.summaryBlock.visible(this.dimension != null);
        if (!this.summaryBlock.isVisible()) {
            return;
        }
        this.dimensionLink.title(this.dimension != null ? this.dimensionLabelProvider.apply(this.dimension.name()) : null);
        this.dimensionLink.readonly(this.readonly);
        this.selectedCategories.clear();
        this.categories.forEach(c -> this.fill((String)c, (CategoryTag)this.selectedCategories.add()));
        this.detailsLink.visible(this.dimension != null && !this.categories.isEmpty());
        this.editAction.visible(this.dimension != null && !this.categories.isEmpty() && !this.categoriesSelectorBlock.isVisible());
        this.editAction.readonly(this.readonly);
        this.continueAction.visible(this.canContinue());
        this.continueAction.readonly(this.readonly || this.categories.isEmpty());
    }

    private void refreshBlocks() {
        this.dimensionSelectorBlock.hide();
        this.categoriesSelectorBlock.hide();
        if (this.dimension == null) {
            this.dimensionSelectorBlock.show();
        }
        if (this.dimension != null && this.categories.isEmpty()) {
            this.categoriesSelectorBlock.show();
        }
    }

    private void initDimensionSelectorBlock() {
        this.dimensionSelector.onSelect(this::updateDimension);
    }

    private void refreshDimensionSelectorBlock() {
        this.dimensionSelector.clear();
        this.dimensionSelector.addAll(this.dimensions.stream().map(d -> this.dimensionLabelProvider.apply(d.name())).collect(Collectors.toList()));
    }

    private void initCategoriesSelectorBlock() {
        this.zoomSelector.onSelect(this::selectZoomLevel);
        this.initBarChart();
    }

    private void initBarChart() {
        this.cubeBarChart.clear();
        CubeBarChart display = new CubeBarChart((SumusBox)this.box());
        display.id(UUID.randomUUID().toString());
        this.cubeBarChart.display(display);
        this.barChart().mode(CubeBarChartInfo.Mode.Storyboard);
        this.barChart().sort("greater");
        this.barChart().source(this.source);
        this.barChart().timetag(this.source.timetag());
        this.barChart().divideBy("Sin dividir");
        this.barChart().onSelectDrillCategory(this::updateFilters);
    }

    private CubeBarChart barChart() {
        return (CubeBarChart)this.cubeBarChart.display();
    }

    private void refreshCategoriesSelectorBlock() {
        this.refreshLevelSelector();
        this.refreshBarChart();
    }

    private void refreshLevelSelector() {
        int levels = this.dimension.levels();
        this.categoriesSelectorBlock.categoriesSelectorHeader.levelBlock.visible(levels > 1);
        if (levels <= 1) {
            return;
        }
        this.zoomSelector.clear();
        for (int i = 0; i < levels; ++i) {
            this.zoomSelector.add(this.translate("Level") + " " + (i + 1));
        }
        this.zoomSelector.selection(new String[]{this.translate("Level") + " 1"});
    }

    private void refreshBarChart() {
        this.barChart().drill(this.dimension.name());
        this.barChart().zoomLevel(this.zoomLevel);
        this.barChart().drillCategories(this.categories);
        this.barChart().indicator(this.indicatorLabelProvider.apply(this.indicator));
        this.barChart().refresh();
    }

    private void updateDimension(SelectionEvent event) {
        String selected = !event.selection().isEmpty() ? (String)event.selection().get(0) : null;
        Dimension dimension = this.dimensions.stream().filter(d -> this.dimensionLabelProvider.apply(d.name()).equals(selected)).findFirst().orElse(null);
        this.selectListener.accept(dimension);
    }

    private void updateDimension(Dimension dimension) {
        this.selectListener.accept(dimension);
    }

    private void updateFilters(List<String> categoryList) {
        this.categories.clear();
        this.categories.addAll(categoryList);
        this.refreshSummary();
    }

    private void filter() {
        this.filterListener.accept(this.dimension, this.categories);
    }

    private void showDetails() {
        this.showDetailsListener.accept(this.dimension, this.categories);
    }

    private void showCategoriesBlock() {
        this.categoriesSelectorBlock.show();
        this.editAction.visible(this.dimension != null && !this.categories.isEmpty() && !this.categoriesSelectorBlock.isVisible());
        this.editAction.readonly(this.readonly);
        this.continueAction.visible(this.canContinue());
        this.continueAction.readonly(this.readonly || this.categories.isEmpty());
        this.refreshSummary();
    }

    private boolean canContinue() {
        return this.dimension != null && this.categoriesSelectorBlock.isVisible();
    }

    private void fill(String category, CategoryTag display) {
        display.category(category);
        display.canRemove(!this.readonly && this.canContinue());
        display.onRemove(e -> {
            this.categories.remove(category);
            this.refreshSummary();
            this.barChart().updateDrillCategoriesSelection(this.categories);
        });
        display.refresh();
    }

    private void selectZoomLevel(SelectionEvent e) {
        List selection = e.selection();
        if (selection.isEmpty()) {
            return;
        }
        this.zoomLevel = Integer.parseInt(((String)selection.get(0)).split(" ")[1]);
        this.refreshBarChart();
    }
}

