/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays.templates;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.core.Box;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.schemas.MicrositeParams;
import io.intino.sumus.box.schemas.ViewFilterParams;
import io.intino.sumus.box.schemas.ViewNodeParams;
import io.intino.sumus.box.schemas.ViewParams;
import io.intino.sumus.box.ui.displays.ReportRenderer;
import io.intino.sumus.box.ui.displays.notifiers.ReportTemplateNotifier;
import io.intino.sumus.box.ui.displays.templates.AbstractReportTemplate;
import io.intino.sumus.box.ui.displays.templates.CubeAnalyzeTemplate;
import io.intino.sumus.box.ui.displays.templates.StoryboardEntryTemplate;
import io.intino.sumus.box.util.StringHelper;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Storyboard;
import io.intino.sumus.reporting.model.Scale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReportTemplate
extends AbstractReportTemplate<ReportTemplateNotifier, SumusBox> {
    private String dashboard;
    private String report;
    private Timetag period;
    private Scale scale;
    private String window;
    private String rootNode;
    private String node;
    private String nodeContent;
    private boolean admin;
    private Consumer<String> selectNodeListener;
    private Consumer<Scale> selectScaleListener;
    private Consumer<String> selectWindowListener;
    private Consumer<Timetag> selectPeriodListener;

    public ReportTemplate(Box box) {
        super((SumusBox)box);
    }

    public ReportTemplate dashboard(String dashboard) {
        this.dashboard = dashboard;
        return this;
    }

    public ReportTemplate report(String report) {
        this.report = report;
        return this;
    }

    public ReportTemplate period(String period) {
        return this.period(new Timetag(period));
    }

    public ReportTemplate period(Timetag period) {
        this.period = period;
        return this;
    }

    public ReportTemplate scale(Scale scale) {
        this.scale = scale;
        return this;
    }

    public ReportTemplate window(String window) {
        this.window = window;
        return this;
    }

    public ReportTemplate rootNode(String node) {
        this.rootNode = node;
        this.node = node;
        return this;
    }

    public ReportTemplate node(String node) {
        this.node = node;
        if (this.rootNode == null) {
            this.rootNode = node;
        }
        return this;
    }

    public ReportTemplate admin(String value) {
        return this.admin(Boolean.parseBoolean(value));
    }

    public ReportTemplate admin(boolean value) {
        this.admin = value;
        return this;
    }

    public void open(String report) {
        this.report = report;
        this.refresh();
    }

    public ReportTemplate onSelectNode(Consumer<String> listener) {
        this.selectNodeListener = listener;
        return this;
    }

    public ReportTemplate onSelectScale(Consumer<Scale> listener) {
        this.selectScaleListener = listener;
        return this;
    }

    public ReportTemplate onSelectWindow(Consumer<String> listener) {
        this.selectWindowListener = listener;
        return this;
    }

    public ReportTemplate onSelectPeriod(Consumer<Timetag> listener) {
        this.selectPeriodListener = listener;
        return this;
    }

    public void didMount() {
        super.didMount();
        this.reportDisplay.display(this.initReportRenderer());
        this.refreshReport(true);
    }

    @Override
    public void init() {
        super.init();
        this.printPage.onExecute(e -> ((ReportRenderer)this.reportDisplay.display()).printPage());
    }

    public void refresh() {
        super.refresh();
        this.refreshReport(true);
    }

    private ReportRenderer initReportRenderer() {
        ReportRenderer result = new ReportRenderer((SumusBox)this.box());
        result.id(this.reportDisplay.display() != null ? this.reportDisplay.display().id() : UUID.randomUUID().toString());
        result.onOpenNode(this::openNode);
        result.onOpenView(this::openView);
        result.onOpenViewNode(this::openView);
        result.onOpenViewFilter(this::openView);
        result.onOpenReport(this::openReport);
        result.onSelectScale(this::notifyScaleSelected);
        result.onSelectWindow(this::notifyWindowSelected);
        result.onSelectPeriod(this::notifyPeriodSelected);
        return result;
    }

    private void openNode(String node) {
        this.node = node;
        this.notifyNodeSelected(node);
        this.refresh();
    }

    private String openView(ViewParams params) {
        return this.viewContent(params.view(), params.period(), this.node);
    }

    private String openView(ViewNodeParams params) {
        String node = params.node() != null ? params.node() : this.node;
        return this.viewContent(params.view(), params.period(), node);
    }

    private String openView(ViewFilterParams params) {
        return this.viewContent(params.view(), params.period(), this.node);
    }

    private String openReport(String report) {
        return StringHelper.translateContent(this.reportNodeContent(report), this.admin, this.rootNode, this.translator());
    }

    private void refreshReport(boolean force) {
        if (this.dashboard == null || this.report == null || this.period == null || this.node == null) {
            return;
        }
        this.refreshNode(force);
        this.refreshToolbar();
    }

    private void refreshNode(boolean force) {
        String nodeContent = this.reportNodeContent();
        if (!force && this.nodeContent != null && this.nodeContent.equals(nodeContent)) {
            return;
        }
        this.nodeContent = nodeContent;
        boolean existsReport = this.nodeContent != null;
        this.noReportBlock.visible(!existsReport);
        this.reportBlock.hide();
        if (!existsReport) {
            return;
        }
        this.loadingBlock.show();
        ReportRenderer renderer = this.reportRenderer();
        if (renderer == null) {
            return;
        }
        renderer.dashboard(this.dashboard);
        renderer.content(StringHelper.translateContent(this.nodeContent, this.admin, this.rootNode, this.translator()));
        renderer.refresh();
        this.loadingBlock.hide();
        this.reportBlock.show();
    }

    private ReportRenderer reportRenderer() {
        if (this.reportDisplay.display() == null) {
            this.reportDisplay.display(this.initReportRenderer());
        }
        return (ReportRenderer)this.reportDisplay.display();
    }

    private void refreshToolbar() {
        Dashboard definition = ((SumusBox)this.box()).dashboardDefinition(this.dashboard);
        this.refreshAnalyzeList(definition);
        this.refreshStoryboardList(definition);
    }

    private void refreshAnalyzeList(Dashboard definition) {
        Dashboard.Report report = definition.report(this.report);
        ArrayList ledgers = report != null ? new ArrayList(report.ledgers()) : Collections.emptyList();
        this.analyzeListBlock.visible(this.scale == Scale.Day && !ledgers.isEmpty());
        if (this.scale != Scale.Day) {
            return;
        }
        this.analyzeList.clear();
        ledgers.forEach(l -> this.fill((String)l, (CubeAnalyzeTemplate)this.analyzeList.add()));
    }

    private void fill(String ledger, CubeAnalyzeTemplate display) {
        display.dashboard(this.dashboard);
        display.cube(ledger);
        display.period(this.period);
        display.node(this.node);
        display.onOpenMicrosite(this::openMicrosite);
        display.refresh();
    }

    private void refreshStoryboardList(Dashboard definition) {
        Dashboard.Report reportDefinition = definition.report(this.report);
        List definitions = reportDefinition != null ? reportDefinition.storyboards() : Collections.emptyList();
        this.storyboardListBlock.visible(this.scale == Scale.Day && !definitions.isEmpty());
        if (this.scale != Scale.Day) {
            return;
        }
        this.storyboardList.clear();
        definitions.forEach(d -> this.fill((Storyboard)d, (StoryboardEntryTemplate)this.storyboardList.add()));
    }

    private void fill(Storyboard definition, StoryboardEntryTemplate display) {
        display.dashboard(this.dashboard);
        display.storyboard(definition);
        display.period(this.period);
        display.node(this.node);
        display.refresh();
    }

    private void openMicrosite(MicrositeParams params) {
        ((ReportRenderer)this.reportDisplay.display()).openMicrosite(params);
    }

    private Function<String, String> translator() {
        Map<String, String> translations = this.ledgerTranslations();
        translations.putAll(((SumusBox)this.box()).dashboardTranslations(this.dashboard, this.language()));
        return word -> translations.getOrDefault(word, (String)word);
    }

    private Map<String, String> ledgerTranslations() {
        Dashboard.Report reportDefinition = ((SumusBox)this.box()).dashboardDefinition(this.dashboard).report(this.report);
        if (reportDefinition == null) {
            return new HashMap<String, String>();
        }
        return reportDefinition.ledgers().stream().map(l -> ((SumusBox)this.box()).ledgerTranslations((String)l, this.language())).reduce((map1, map2) -> Stream.concat(map1.entrySet().stream(), map2.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (translation1, translation2) -> translation1))).orElse(new HashMap());
    }

    private String reportNodeContent() {
        return this.reportNodeContent(this.report);
    }

    private String reportNodeContent(String report) {
        Dashboard dashboardDef = ((SumusBox)this.box()).dashboardDefinition(this.dashboard);
        Dashboard.Report reportDef = dashboardDef.report(report);
        if (reportDef == null) {
            return "";
        }
        if (dashboardDef.isRealtime() || reportDef.isRealtime()) {
            return ((SumusBox)this.box()).realtimeBuilder().build(this.dashboard, report, this.period, this.node);
        }
        if (reportDef.isSingleton()) {
            return ((SumusBox)this.box()).singletonReportNode(this.dashboard, report, this.node);
        }
        return ((SumusBox)this.box()).reportNode(this.dashboard, report, this.period, this.scale, this.window, this.node);
    }

    private String viewContent(String view, String period, String node) {
        return ((SumusBox)this.box()).viewNode(this.dashboard, view, new Timetag(period), node);
    }

    private void notifyNodeSelected(String node) {
        if (this.selectNodeListener == null) {
            return;
        }
        this.selectNodeListener.accept(node);
    }

    private void notifyScaleSelected(Scale scale) {
        if (this.selectScaleListener == null) {
            return;
        }
        this.selectScaleListener.accept(this.scale);
    }

    private void notifyWindowSelected(String window) {
        if (this.selectWindowListener == null) {
            return;
        }
        this.selectWindowListener.accept(window);
    }

    private void notifyPeriodSelected(Timetag period) {
        if (this.selectPeriodListener == null || period == null) {
            return;
        }
        this.selectPeriodListener.accept(period);
    }
}

