/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays.templates;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.components.TemporalSlider;
import io.intino.alexandria.ui.displays.components.selector.Selector;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.dynamictable.Section;
import io.intino.alexandria.ui.spark.UIFile;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.datasources.CubeDatasource;
import io.intino.sumus.box.ui.datasources.MicroSiteBuilderOfCube;
import io.intino.sumus.box.ui.displays.DisplayHelper;
import io.intino.sumus.box.ui.displays.templates.AbstractCubeDialog;
import io.intino.sumus.box.ui.displays.templates.AttachedTemplateItem;
import io.intino.sumus.box.util.DocumentGenerator;
import io.intino.sumus.box.util.Formatters;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Slice;
import java.io.InputStream;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class CubeDialog
extends AbstractCubeDialog<SumusBox> {
    private CubeDatasource source;
    private Timetag timetag;
    private Consumer<Timetag> selectTimetagListener;
    private BiConsumer<String, Boolean> selectDrillListener;
    private BiConsumer<String, Boolean> selectDivideByListener;
    private Consumer<Integer> zoomLevelListener;
    private Consumer<Boolean> transposeListener;
    private Consumer<Boolean> resetFiltersListener;
    private Consumer<Map<String, List<String>>> applyFiltersListener;
    private Consumer<String> attachDimensionListener;
    private Consumer<View> selectViewListener;
    private Instant fromValue = null;
    private Instant toValue = null;
    private boolean transposing = false;
    private View view;
    private Map<String, List<String>> suggestedFilters = new HashMap<String, List<String>>();
    private static List<Dimension> allowedAttachList = Arrays.asList(new Dimension[0]);

    public void didMount() {
        super.didMount();
        this.refreshAttach(this.drill());
    }

    public CubeDialog(Box box) {
        super((SumusBox)box);
    }

    public Timetag timetag() {
        return this.timetag;
    }

    public CubeDialog source(CubeDatasource source) {
        this.source = source;
        this.timetag = this.timetag == null ? new Timetag(this.rangeTo(), source.scale()) : this.timetag;
        this.viewSelector.select(new String[]{this.selectedViewName()});
        this.notifyResetFilters();
        return this;
    }

    public void updateFiltersMessage(Map<String, List<String>> filters) {
        String message = filters.entrySet().stream().map(this::filtersMessage).collect(Collectors.joining(". "));
        this.filtersBlock.visible(!message.isEmpty());
        this.filtersMessage.value(message);
    }

    public void suggestedFilters(Map<String, List<String>> selection) {
        this.suggestedFilters = this.filtersFrom(selection);
        String message = this.suggestedFilters.entrySet().stream().map(e -> this.filtersMessage((String)e.getKey(), (List)e.getValue())).collect(Collectors.joining(". "));
        this.suggestedFiltersBlock.visible(this.suggestedFilters.size() > 0);
        this.suggestedFiltersMessage.value(message);
    }

    private Map<String, List<String>> filtersFrom(Map<String, List<String>> selection) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if ((selection = selection.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).size() <= 0) {
            return result;
        }
        Dimension drill = this.source.findDimension(this.source.drillAfterTranspose());
        result.put(drill.name(), selection.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList()));
        Dimension divideBy = this.source.findDimension(this.source.dimensionAfterTranspose());
        if (divideBy == null) {
            return result;
        }
        result.put(divideBy.name(), new ArrayList<String>(selection.keySet()));
        return result;
    }

    public CubeDialog onSelectTimetag(Consumer<Timetag> listener) {
        this.selectTimetagListener = listener;
        return this;
    }

    public CubeDialog onSelectDrill(BiConsumer<String, Boolean> listener) {
        this.selectDrillListener = listener;
        return this;
    }

    public CubeDialog onSelectDivideBy(BiConsumer<String, Boolean> listener) {
        this.selectDivideByListener = listener;
        return this;
    }

    public CubeDialog onSelectZoomLevel(Consumer<Integer> listener) {
        this.zoomLevelListener = listener;
        return this;
    }

    public CubeDialog onTranspose(Consumer<Boolean> listener) {
        this.transposeListener = listener;
        return this;
    }

    public CubeDialog onResetFilters(Consumer<Boolean> listener) {
        this.resetFiltersListener = listener;
        return this;
    }

    public CubeDialog onApplyFilters(Consumer<Map<String, List<String>>> listener) {
        this.applyFiltersListener = listener;
        return this;
    }

    public CubeDialog onAttachDimension(Consumer<String> listener) {
        this.attachDimensionListener = listener;
        return this;
    }

    public CubeDialog onSelectView(Consumer<View> listener) {
        this.selectViewListener = listener;
        return this;
    }

    public String drill() {
        return this.drillSelector.selection().size() > 0 ? (String)this.drillSelector.selection().get(0) : null;
    }

    public void selectDrill(String drill) {
        if (this.distinctDrill(drill)) {
            this.source.zoomLevel(1);
            this.source.attachedValues(new HashMap<Dimension, Slice>());
            this.refreshDrillOptions();
        }
        this.source.transpose(false);
        this.refreshAttach(drill);
        this.refreshDimensionOptions();
        this.notifyDrillSelected(drill);
    }

    private boolean distinctDrill(String drill) {
        Map<Dimension, Slice> attached = this.source.attachedValues();
        Dimension drillDimension = this.source.findDimension(drill);
        return !this.source.drill().equals(drill);
    }

    public String dimension() {
        return this.dimensionSelector.selection().isEmpty() ? null : (String)this.dimensionSelector.selection().get(0);
    }

    public void selectDimension(String dimension) {
        this.source.transpose(false);
        this.refreshDrillOptions();
        this.notifyDivideBySelected(dimension);
    }

    @Override
    public void init() {
        super.init();
        this.initToolbar();
        this.initTimetag();
        this.initSelectors();
        this.initAttachDialog();
        this.initViewSelector();
    }

    public void refresh() {
        super.refresh();
        if (this.source == null) {
            return;
        }
        this.refreshTimetag();
        this.refreshSelectors();
        this.refreshAttach(this.drill());
    }

    private void initToolbar() {
        this.download.onExecute(e -> this.downloadData());
        this.viewDetails.onExecute(e -> this.viewDetails());
        this.resetFilters.onExecute(e -> this.notifyResetFilters());
        this.applyFilters.onExecute(e -> this.notifyApplyFilters());
    }

    private void initTimetag() {
        this.initSlider(this.navigationSelector);
    }

    private void initSelectors() {
        this.dimensionSelector.onSelect(this::selectDimension);
        this.drillSelector.onSelect(this::selectDrill);
        this.transpose.onExecute(e -> this.transpose());
        this.zoomSelector.onSelect(this::selectZoomLevel);
    }

    private void initSlider(TemporalSlider slider) {
        slider.onChange(e -> {
            if (this.source == null) {
                return;
            }
            this.timetag = new Timetag((Instant)e.value(), this.source.scale());
            this.notifyTimetagSelected();
        });
        slider.formatter(value -> {
            if (this.source == null) {
                return null;
            }
            return Timetag.of((LocalDateTime)LocalDateTime.ofInstant(Instant.ofEpochMilli(value), ZoneOffset.UTC), (Scale)this.source.scale()).label();
        });
    }

    private void initAttachDialog() {
        this.attachDialog.onSelect(e -> this.attachOption(e.selection()));
        this.attachDialog.onBeforeOpen(e -> {
            this.attachDialog.title(this.translate("Select an option to lock %s").replace("%s", this.drill().toLowerCase()));
            List<Group> groups = this.source.groups(this.drill());
            this.attachSelector.clear();
            groups.forEach(g -> this.attachSelector.add(g.label()));
            return true;
        });
    }

    private void initViewSelector() {
        this.viewSelector.onSelect(e -> this.selectView((String)e.selection().get(0)));
    }

    private void notifyResetFilters() {
        this.updateFiltersMessage(Collections.emptyMap());
        List<Dimension> dimensions = this.source.dimensions();
        this.select("Sin dividir", dimensions.size() > 0 ? dimensions.get(0).name() : null);
        this.source.attachedValues(new HashMap<Dimension, Slice>());
        this.refresh();
        if (this.resetFiltersListener != null) {
            this.resetFiltersListener.accept(true);
        }
    }

    private void notifyApplyFilters() {
        HashMap<String, List<String>> suggestion = new HashMap<String, List<String>>(this.suggestedFilters);
        this.suggestedFilters(Collections.emptyMap());
        if (this.applyFiltersListener != null) {
            this.applyFiltersListener.accept(suggestion);
        }
    }

    private void selectView(String view) {
        if (this.selectViewListener == null) {
            return;
        }
        this.view = this.viewOf(view);
        this.selectViewListener.accept(this.view);
    }

    private View viewOf(String view) {
        if (view.equalsIgnoreCase("listView")) {
            return View.ListView;
        }
        if (view.equalsIgnoreCase("tableView")) {
            return View.TableView;
        }
        return View.BarChartView;
    }

    private String selectedViewName() {
        if (this.view == null || this.view == View.ListView) {
            return "listView";
        }
        if (this.view == View.TableView) {
            return "tableView";
        }
        return "barChartView";
    }

    private void refreshTimetag() {
        this.refreshSlider(this.navigationSelector);
        this.timetagViewer.value(Formatters.date(Formatters.instantOf(this.navigationSelector.timetag()), DisplayHelper.format(this.navigationSelector.timetag().scale()), this.language()));
    }

    private void refreshSelectors() {
        String dimension = this.source.dimension();
        String drill = this.drill();
        this.refreshDimensionOptions();
        this.dimensionSelector.selection(new String[]{dimension != null && !dimension.equals("Sin dividir") ? this.source.findDimension(dimension).name() : "Sin dividir"});
        this.refreshDrillOptions();
        if (drill != null) {
            this.drillSelector.selection(new String[]{this.source.translate(this.source.findDimension(drill).name())});
        }
        this.refreshTranspose();
        this.refreshZoomLevels(drill);
    }

    private Dimension defaultDimension() {
        List<Dimension> dimensions = this.source.dimensions();
        return dimensions.size() > 0 ? dimensions.get(0) : null;
    }

    private void refreshSlider(TemporalSlider slider) {
        Instant min = this.source.range().from();
        Instant max = this.rangeTo();
        slider.range(min, max);
        slider.value(this.source.timetag() != null ? Formatters.instantOf(this.source.timetag()) : max);
        slider.selectOrdinal(this.source.scale().name());
    }

    private void refreshAttach(String drill) {
        if (this.source == null) {
            return;
        }
        this.attachedElements.visible(this.source.attachedValues().size() > 0);
        this.attachLink.visible(drill != null && this.canAttach(drill));
        this.attachLink.title(this.translate("Lock") + " " + drill);
        this.refreshAttachedElements();
    }

    private UIFile downloadData() {
        return new UIFile(){

            public String label() {
                return CubeDialog.this.source.name().replace(" ", "_") + "_" + Formatters.downloadDate(Formatters.instantOf(CubeDialog.this.timetag), CubeDialog.this.language(), "xls");
            }

            public InputStream content() {
                DocumentGenerator generator = new DocumentGenerator(CubeDialog.this.source, ((SumusBox)CubeDialog.this.box()).logoContent());
                return generator.generate(CubeDialog.this.timetag, CubeDialog.this.source.dimension(), CubeDialog.this.drill(), CubeDialog.this.source.condition(), CubeDialog.this.source.filters());
            }
        };
    }

    private void viewDetails() {
        this.notifyUser(this.translate("Generating report. This operation may take time. Please wait..."), UserMessage.Type.Loading);
        Section section = new Section("Sin dividir");
        Timetag timetag = new Timetag(Instant.now(), Scale.Day);
        MicroSiteBuilderOfCube builder = new MicroSiteBuilderOfCube((SumusBox)this.box(), DisplayHelper.cellProvider((SumusBox)this.box(), this.source), this.language());
        Iterator<Fact> details = this.source.details(this.source.timetag(), section, null, this.source.filters());
        String result = builder.build(timetag, this.source.title(), this.source.description(section.label(), null), this.source.itemColumns(), details);
        this.notifyUser(this.translate("Report generated"), UserMessage.Type.Success);
        String url = ((SumusBox)this.box()).configuration().url();
        this.openSite.site(url + (url.endsWith("/") ? "" : "/") + "drills/" + timetag + "/" + result + "/");
        this.openSite.launch();
    }

    private void attachOption(List<String> selection) {
        if (selection.size() <= 0) {
            return;
        }
        Dimension from = this.source.findDimension(this.drill());
        this.source.putAttachedValue(from, this.source.slice(from, selection.get(0)));
        this.refreshAttachedElements();
        this.refreshDimensionOptions();
        this.refreshDrillOptions();
        this.notifyDimensionAttached(from);
        Dimension dimension = this.dimensionChildOf(this.drill(), selection.get(0));
        if (dimension != null) {
            this.drillSelector.select(new String[]{this.source.translate(dimension.name())});
        } else {
            this.drillSelector.select(new String[0]);
        }
    }

    private Dimension dimensionChildOf(String drillName, String value) {
        Dimension drill = this.source.findDimension(drillName);
        return null;
    }

    private void selectDimension(SelectionEvent e) {
        List selection = e.selection();
        if (selection.size() <= 0) {
            return;
        }
        boolean isNoSelection = ((String)selection.get(0)).equals("Sin dividir");
        this.selectDimension(isNoSelection ? "Sin dividir" : this.source.findDimension((String)selection.get(0)).name());
        this.suggestedFilters(Collections.emptyMap());
        if (isNoSelection) {
            this.viewSelector.disableOptions(new String[]{"tableView"});
        } else {
            this.viewSelector.enableOptions(new String[]{"tableView"});
        }
    }

    private void selectDrill(SelectionEvent e) {
        List selection = e.selection();
        String drill = selection.size() > 0 ? this.source.findDimension((String)selection.get(0)).name() : null;
        this.selectDrill(drill);
        this.suggestedFilters(Collections.emptyMap());
        this.refreshZoomLevels(drill);
    }

    private void selectZoomLevel(SelectionEvent e) {
        List selection = e.selection();
        if (selection.size() <= 0) {
            return;
        }
        int level = Integer.parseInt(((String)selection.get(0)).split(" ")[1]);
        this.source.zoomLevel(level);
        this.notifyZoomLevelSelected(level);
    }

    private void refreshZoomLevels(String drill) {
        if (drill == null) {
            return;
        }
        Dimension dimension = this.source.findDimension(drill);
        int levels = dimension.levels();
        this.levelBlock.visible(levels > 1);
        if (levels <= 1) {
            return;
        }
        this.zoomSelector.clear();
        for (int i = 0; i < levels; ++i) {
            this.zoomSelector.add(this.translate("Level") + " " + (i + 1));
        }
        this.zoomSelector.selection(new String[]{this.translate("Level") + " 1"});
    }

    public void select(String dimension, String drill) {
        this.source.dimension(dimension);
        this.source.drill(drill);
        this.transposing = true;
        this.drillSelector.select(new String[]{this.source.translate(drill)});
        this.transposing = false;
        this.dimensionSelector.select(new String[]{dimension != null && !dimension.equals("Sin dividir") ? this.source.translate(dimension) : "Sin dividir"});
    }

    private void selectInstant(Instant instant) {
        if (this.source == null) {
            return;
        }
        this.timetag = new Timetag(instant, this.source.scale());
        this.navigationSelector.value(Formatters.instantOf(this.timetag));
        this.notifyTimetagSelected();
    }

    public void selectTimetag(Timetag timetag) {
        this.timetag = timetag;
        this.timetagViewer.value(Formatters.date(Formatters.instantOf(timetag), DisplayHelper.format(timetag.scale()), this.language()));
        this.navigationSelector.value(Formatters.instantOf(timetag));
        this.notifyTimetagSelected();
    }

    private void refreshAttachedElements() {
        this.attachedElements.visible(this.source.attachedValues().size() > 0);
        this.attachedElements.clear();
        this.source.attachedValues().forEach((key, value) -> this.fillAttachedOption((AttachedTemplateItem)this.attachedElements.add(), (Dimension)key, value.name()));
    }

    private void fillAttachedOption(AttachedTemplateItem view, Dimension dimension, String value) {
        view.name(dimension.name());
        view.value(value);
        view.onRemove(this::unAttachOption);
        view.refresh();
    }

    private void unAttachOption(String name, String value) {
        Dimension dimension = this.source.findDimension(name);
        this.source.removeAttachedValue(dimension);
        this.refreshAttachedElements();
        this.refreshDimensionOptions();
        this.refreshDrillOptions();
        this.transposing = true;
        this.dimensionSelector.select(new String[]{"Sin dividir"});
        this.transposing = false;
        this.drillSelector.select(new String[]{this.source.translate(name)});
    }

    private void refreshDimensionOptions() {
        this.dimensionSelector.clear();
        List options = this.selectorOptions((Selector)this.drillSelector).stream().sorted().collect(Collectors.toList());
        options.add(0, "Sin dividir");
        this.dimensionSelector.addAll(options);
        this.refreshTranspose();
    }

    private void refreshDrillOptions() {
        this.drillSelector.clear();
        List options = this.selectorOptions((Selector)this.dimensionSelector).stream().sorted().collect(Collectors.toList());
        this.drillSelector.addAll(options);
        this.refreshTranspose();
    }

    private List<String> selectorOptions(Selector excludedOptions) {
        HashSet<Dimension> excluded = new HashSet<Dimension>(Arrays.asList(new Dimension[0]));
        Map<Dimension, Slice> attachedMap = this.source.attachedValues();
        if (excludedOptions.selection().size() > 0) {
            excluded.add(this.source.findDimension((String)excludedOptions.selection().get(0)));
        }
        return this.source.dimensions().stream().filter(o -> !excluded.contains(o) && !attachedMap.containsKey(o)).map(d -> this.source.translate(d.name())).collect(Collectors.toList());
    }

    private void refreshTranspose() {
        List selection = this.dimensionSelector.selection();
        this.transpose.readonly(selection.size() <= 0 || ((String)selection.get(0)).equals("Sin dividir"));
    }

    private boolean canAttach(String drill) {
        return allowedAttachList.contains(this.source.findDimension(drill));
    }

    private void notifyTimetagSelected() {
        if (this.selectTimetagListener == null) {
            return;
        }
        this.selectTimetagListener.accept(this.timetag);
    }

    private void notifyDrillSelected(String drill) {
        if (this.selectDrillListener == null) {
            return;
        }
        this.selectDrillListener.accept(drill, this.transposing);
    }

    private void notifyDivideBySelected(String divideBy) {
        if (this.selectDivideByListener == null) {
            return;
        }
        this.selectDivideByListener.accept(divideBy, this.transposing);
    }

    private void notifyZoomLevelSelected(int zoomLevel) {
        if (this.zoomLevelListener == null) {
            return;
        }
        this.zoomLevelListener.accept(zoomLevel);
    }

    private void notifyDimensionAttached(Dimension dimension) {
        if (this.attachDimensionListener == null) {
            return;
        }
        this.attachDimensionListener.accept(dimension.name());
    }

    private Instant rangeTo() {
        return this.source.range().to();
    }

    private void transpose() {
        this.select(this.drill(), this.dimension());
    }

    private String filtersMessage(Map.Entry<String, List<String>> entry) {
        return this.filtersMessage(this.source.translate(entry.getKey()), this.filterMessageValues(entry));
    }

    private String filtersMessage(Dimension drill, String dimension, List<String> values) {
        return this.source.translate(drill.name()) + "(" + String.join((CharSequence)", ", values) + ")";
    }

    private String filtersMessage(String dimension, List<String> values) {
        return this.source.translate(dimension) + "(" + String.join((CharSequence)", ", values) + ")";
    }

    private List<String> filterMessageValues(Map.Entry<String, List<String>> entry) {
        Dimension dimension = this.source.findDimension(entry.getKey());
        List slices = dimension.slices();
        return entry.getValue().stream().map(v -> slices.stream().filter(c -> c.name().equals(v) || this.source.translate(c.name()).equals(v)).findFirst().orElse(null)).filter(Objects::nonNull).map(s -> this.source.translate(s.name())).collect(Collectors.toList());
    }

    public static enum View {
        ListView,
        BarChartView,
        TableView;

    }
}

