/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.ui.displays.Component;
import io.intino.alexandria.ui.displays.components.DateEditable;
import io.intino.alexandria.ui.displays.components.Layer;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.datasources.CubeDatasource;
import io.intino.sumus.box.ui.datasources.ItemColumn;
import io.intino.sumus.box.ui.datasources.MicroSiteBuilderOfCube;
import io.intino.sumus.box.ui.displays.templates.AppTemplate;
import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.dimensions.Category;
import io.intino.sumus.model.AttributeDefinition;
import io.intino.sumus.reporting.Dashboard;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DisplayHelper {
    public static DateEditable.View viewOf(io.intino.sumus.reporting.model.Scale scale) {
        if (scale == io.intino.sumus.reporting.model.Scale.Year) {
            return DateEditable.View.Year;
        }
        if (scale == io.intino.sumus.reporting.model.Scale.Month) {
            return DateEditable.View.Month;
        }
        if (scale == io.intino.sumus.reporting.model.Scale.Week) {
            return DateEditable.View.Week;
        }
        return DateEditable.View.Date;
    }

    public static List<DateEditable.View> views(Dashboard.Report definition) {
        return definition != null ? definition.scales().stream().map(DisplayHelper::viewOf).collect(Collectors.toList()) : Collections.singletonList(DateEditable.View.Date);
    }

    public static List<DateEditable.View> views(Scale scale) {
        if (scale == Scale.Year) {
            return Collections.singletonList(DateEditable.View.Year);
        }
        if (scale == Scale.Month) {
            return Collections.singletonList(DateEditable.View.Month);
        }
        return Collections.singletonList(DateEditable.View.Date);
    }

    public static String pattern(io.intino.sumus.reporting.model.Scale scale) {
        if (scale == io.intino.sumus.reporting.model.Scale.Year) {
            return "YYYY";
        }
        if (scale == io.intino.sumus.reporting.model.Scale.Quarter) {
            return "[Quarter] Q";
        }
        if (scale == io.intino.sumus.reporting.model.Scale.Month) {
            return "YYYY-MM";
        }
        if (scale == io.intino.sumus.reporting.model.Scale.Week) {
            return "[Week] YYYY-ww";
        }
        return "YYYY-MM-DD";
    }

    public static String pattern(Scale scale) {
        if (scale == Scale.Year) {
            return "YYYY";
        }
        if (scale == Scale.Month) {
            return "YYYY-MM";
        }
        if (scale == Scale.Day) {
            return "YYYY-MM-DD";
        }
        return "YYYY";
    }

    public static String format(Scale scale) {
        if (scale == Scale.Year) {
            return "YYYY";
        }
        if (scale == Scale.Month) {
            return "YYYY-MM";
        }
        if (scale == Scale.Day) {
            return "YYYY-MM-dd";
        }
        return "YYYY";
    }

    public static Scale timetagScaleOf(io.intino.sumus.reporting.model.Scale scale) {
        if (scale == io.intino.sumus.reporting.model.Scale.Year) {
            return Scale.Year;
        }
        if (scale == io.intino.sumus.reporting.model.Scale.Month) {
            return Scale.Month;
        }
        return Scale.Day;
    }

    public static io.intino.sumus.reporting.model.Scale scaleOf(Timetag period) {
        if (period.scale() == Scale.Year) {
            return io.intino.sumus.reporting.model.Scale.Year;
        }
        if (period.scale() == Scale.Month) {
            return io.intino.sumus.reporting.model.Scale.Month;
        }
        return io.intino.sumus.reporting.model.Scale.Day;
    }

    public static void fillLayer(SumusBox box, Layer<?, ?> layer, String title) {
        layer.title(title);
        AppTemplate template = new AppTemplate(box);
        layer.template((Component)template);
        template.embedded(true);
    }

    public static MicroSiteBuilderOfCube.CellProvider cellProvider(SumusBox box, final CubeDatasource source) {
        return new MicroSiteBuilderOfCube.CellProvider(){

            @Override
            public String id(Fact fact) {
                return fact.attributes().isEmpty() ? null : String.valueOf(this.valueOf((Attribute)fact.attributes().get(0), fact.value((Attribute)fact.attributes().get(0))));
            }

            @Override
            public Map<String, Object> cells(Fact fact) {
                return source.itemColumns().stream().collect(Collectors.toMap(a -> a.label, a -> this.valueOf(fact, (ItemColumn)a), (a, b) -> a, LinkedHashMap::new));
            }

            private Object valueOf(Fact fact, ItemColumn column) {
                Attribute attribute = fact.attributes().stream().filter(a -> a.name().equals(column.label)).findFirst().orElse(null);
                String result = fact.value(column.label) != null ? fact.value(column.label) : "";
                return this.valueOf(attribute, result);
            }

            private Object valueOf(Attribute attribute, Object result) {
                if (attribute == null) {
                    return result;
                }
                if (result instanceof String) {
                    return result;
                }
                if (attribute.type() == AttributeDefinition.Type.date) {
                    if (result instanceof LocalDate) {
                        return result;
                    }
                    if (result instanceof Timetag) {
                        return ((Timetag)result).label();
                    }
                    return LocalDate.ofEpochDay((Long)result);
                }
                if (attribute.type() == AttributeDefinition.Type.time) {
                    if (result instanceof LocalTime) {
                        return result;
                    }
                    return LocalTime.ofSecondOfDay(((Integer)result).intValue());
                }
                if (result instanceof Category) {
                    return ((Category)result).label;
                }
                if (result instanceof Double || result instanceof Long) {
                    return new BigDecimal(String.valueOf(result)).toPlainString();
                }
                return result;
            }

            @Override
            public String cellLinkOf(Object value, ItemColumn column) {
                if (column.type != ItemColumn.Type.Link) {
                    return null;
                }
                if (value == null || String.valueOf(value).isEmpty()) {
                    return null;
                }
                String baseUrl = column.extraData();
                if (baseUrl == null) {
                    return null;
                }
                return baseUrl + (baseUrl.endsWith("/") ? "" : "/") + value;
            }
        };
    }
}

