/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.model;

import com.google.gson.Gson;
import io.intino.alexandria.logger.Logger;
import io.intino.sumus.reporting.Storyboard;
import java.io.File;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Map;

public class StoryboardDefinition
implements Storyboard {
    private String name;
    private String label;
    private String ledger;
    private Map<String, String> indicators;
    private Map<String, String> dimensions;

    public String name() {
        return this.name != null ? this.name : "unknown";
    }

    public String label() {
        return this.label != null ? this.label : this.name();
    }

    public String ledger() {
        return this.ledger;
    }

    public Map<String, String> indicators() {
        return this.indicators != null ? this.indicators : Collections.emptyMap();
    }

    public Map<String, String> dimensions() {
        return this.dimensions != null ? this.dimensions : Collections.emptyMap();
    }

    public static StoryboardDefinition load(String definition) {
        return (StoryboardDefinition)new Gson().fromJson(definition, StoryboardDefinition.class);
    }

    public static StoryboardDefinition load(File definition) {
        try {
            return StoryboardDefinition.load(Files.readString(definition.toPath()));
        }
        catch (Throwable e) {
            Logger.warn((String)("Failed to open definition: " + definition.getAbsolutePath()));
            return null;
        }
    }
}

