/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.model;

import com.google.gson.Gson;
import io.intino.alexandria.logger.Logger;
import io.intino.sumus.box.model.InsightDefinition;
import io.intino.sumus.box.model.StoryboardDefinition;
import io.intino.sumus.box.model.ViewDefinition;
import io.intino.sumus.box.util.DashboardHelper;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Storyboard;
import io.intino.sumus.reporting.model.CustomIndicator;
import io.intino.sumus.reporting.model.Formatter;
import io.intino.sumus.reporting.model.Scale;
import io.intino.sumus.reporting.model.Visibility;
import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ReportDefinition
implements Dashboard.Report {
    public static final String StoryboardExtension = ".storyboard";
    private String name;
    private String label;
    private String group;
    private String description;
    private String template;
    private Visibility visibility;
    private InsightDefinition[] insights;
    private ViewDefinition[] views;
    private String[] storyboards;
    private CustomIndicator[] customIndicators;
    private Map<String, String> patterns;
    private String[] filters;
    private String[] scales;
    private boolean requireAllLedgers;
    private boolean isSingleton;
    private boolean isRealtime;
    private String storyboardsDirectoryPath;
    private String locale;

    public String name() {
        return this.name;
    }

    public String label() {
        return this.label != null ? this.label : this.name();
    }

    public String group() {
        return this.group;
    }

    public String description() {
        return this.description;
    }

    public String template() {
        return DashboardHelper.content(new File(this.template));
    }

    public List<Dashboard.View> views() {
        if (this.views == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.views).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Dashboard.Insight> insights() {
        if (this.insights == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.insights).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void storyboardsDirectory(File file) {
        if (file == null) {
            return;
        }
        this.storyboardsDirectoryPath = file.getAbsolutePath();
    }

    private void locale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.locale = locale.toLanguageTag();
    }

    public List<Storyboard> storyboards() {
        if (this.storyboardsDirectoryPath == null || this.storyboards == null || this.storyboards.length < 1) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.storyboards).map(name -> new File(new File(this.storyboardsDirectoryPath), name + StoryboardExtension)).map(StoryboardDefinition::load).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Set<String> ledgers() {
        HashSet<String> ledgers = new HashSet<String>();
        ledgers.addAll(this.insightLedgers());
        ledgers.addAll(this.viewLedgers());
        return ledgers;
    }

    private Set<String> insightLedgers() {
        return this.insights().stream().map(Dashboard.Insight::ledger).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Set<String> viewLedgers() {
        return this.views().stream().map(Dashboard.View::ledger).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public List<Scale> scales() {
        return this.scales != null ? Arrays.stream(this.scales).distinct().map(Scale::valueOf).collect(Collectors.toList()) : List.of(Scale.Day);
    }

    public List<CustomIndicator> customIndicators() {
        if (this.customIndicators == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.customIndicators).collect(Collectors.toList());
    }

    public Map<String, Formatter> formatters() {
        if (this.patterns == null) {
            return Collections.emptyMap();
        }
        return this.patterns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new Formatter(this.locale(), (String)e.getValue()), (a, b) -> a));
    }

    public Visibility visibility() {
        return this.visibility != null ? this.visibility : Visibility.All;
    }

    public String[] filters() {
        return this.filters != null ? this.filters : new String[]{};
    }

    public Locale locale() {
        Locale locale = DashboardHelper.localeOf(this.locale);
        return locale != null ? locale : super.locale();
    }

    public boolean requireAllLedgers() {
        return this.requireAllLedgers;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public boolean isRealtime() {
        return this.isRealtime;
    }

    public static ReportDefinition load(String definition, File storyboardsDirectory, Locale locale) {
        ReportDefinition reportDefinition = (ReportDefinition)new Gson().fromJson(definition, ReportDefinition.class);
        reportDefinition.storyboardsDirectory(storyboardsDirectory);
        reportDefinition.locale(locale);
        return reportDefinition;
    }

    public static ReportDefinition load(File definition, File storyboardsDirectory, Locale locale) {
        try {
            return ReportDefinition.load(Files.readString(definition.toPath()), storyboardsDirectory, locale);
        }
        catch (Throwable e) {
            Logger.warn((String)("Failed to open definition: " + definition.getAbsolutePath()));
            return null;
        }
    }
}

