/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.model;

import io.intino.alexandria.Timetag;
import io.intino.sumus.box.util.DashboardHelper;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.model.Order;
import io.intino.sumus.reporting.model.Visibility;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class InsightDefinition
implements Dashboard.Insight {
    private String id;
    private String label;
    private String ledger;
    private Dashboard.Insight.Type type;
    private Visibility visibility;
    private String order;
    private String[] dimensions;
    private String[] filters;
    private String[] dateFilters;
    private String[] indicators;
    private String[] slices;
    private Integer level;
    private String[] formats;
    private Integer maxItems;
    private Map<String, String> labels;
    private Map<String, String> options;
    private String node;

    public String id() {
        return this.id;
    }

    public String label() {
        return this.label != null ? this.label : "";
    }

    public Dashboard.Insight.Type type() {
        return this.type;
    }

    public String ledger() {
        return this.ledger;
    }

    public String[] dimensions() {
        return this.dimensions != null ? this.dimensions : new String[]{};
    }

    public String[] filters(Timetag timetag) {
        if (this.filters == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(this.filters).map(f -> DashboardHelper.getValue(timetag, f)).toArray(String[]::new);
    }

    public String[] indicators() {
        return this.indicators != null ? this.indicators : new String[]{};
    }

    public String[] slices() {
        return this.slices == null ? new String[]{} : this.slices;
    }

    public Integer level() {
        return this.level;
    }

    public Visibility visibility() {
        return this.visibility != null ? this.visibility : Visibility.All;
    }

    public Order order() {
        if (this.order == null) {
            return new Order(Order.Type.Descending);
        }
        if (!this.order.contains(":")) {
            return new Order(Order.Type.valueOf((String)this.order));
        }
        String[] d = this.order.split(":", -1);
        return new Order(Order.Type.valueOf((String)d[0]), d[1]);
    }

    public Integer maxItems() {
        return this.maxItems != null ? this.maxItems : Integer.MAX_VALUE;
    }

    public Map<String, String> labels() {
        return this.labels != null ? this.labels : Collections.emptyMap();
    }

    public Map<String, String> formats() {
        if (this.formats == null) {
            return Collections.emptyMap();
        }
        return Arrays.stream(this.formats).filter(f -> f.contains(":")).map(d -> d.trim().split(":")).collect(Collectors.toMap(d -> d[0], d -> d[1], (a, b) -> a));
    }

    public Map<String, String> options() {
        return this.options != null ? this.options : Collections.emptyMap();
    }

    public Node.Type node() {
        return Arrays.stream(Node.Type.values()).filter(v -> v.name().equalsIgnoreCase(this.node)).findFirst().orElse(null);
    }

    public String[] dateFilters(Timetag timetag) {
        if (this.dateFilters == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(this.dateFilters).map(f -> DashboardHelper.getValue(timetag, f)).toArray(String[]::new);
    }
}

