import Notifier from "./Notifier";

export default class CubeBarChartNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refresh").toSelf().execute((parameters) => this.element.refresh(parameters.v));
		this.when("refreshSeries").toSelf().execute((parameters) => this.element.refreshSeries(parameters.v));
		this.when("refreshSelection").toSelf().execute((parameters) => this.element.refreshSelection(parameters.v));
		this.when("showLoading").toSelf().execute(() => this.element.showLoading());
		this.when("hideLoading").toSelf().execute(() => this.element.hideLoading());
		this.pushLinked = true;
	};
}