import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiMicroSite from "alexandria-ui-elements/src/displays/components/MicroSite";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import SiteTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import SiteTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class SiteTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new SiteTemplateNotifier(this);
		this.requester = new SiteTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiMicroSite context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1407840922" downloadOperations={["DownloadContent"]}>
				</UiMicroSite>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(SiteTemplate));
DisplayFactory.register("SiteTemplate", withStyles(styles, { withTheme: true })(withSnackbar(SiteTemplate)));