/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays.templates;

import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.Theme;
import io.intino.sumus.box.ui.displays.templates.AbstractHeader;
import io.intino.sumus.box.ui.displays.templates.AppTemplate;
import java.net.URL;

public class Header
extends AbstractHeader<SumusBox> {
    private AppTemplate.Page page;

    public Header(SumusBox box) {
        super(box);
    }

    public Header page(AppTemplate.Page page) {
        this.page = page;
        return this;
    }

    public void embedded(boolean embedded) {
        if (!embedded) {
            return;
        }
        this.content.hide();
    }

    @Override
    public void init() {
        super.init();
        this.initLogo();
        this.initTitle();
    }

    public void refresh() {
        super.refresh();
        int dashboardCount = ((SumusBox)this.box()).dashboards().size();
        int cubeCount = ((SumusBox)this.box()).ledgers().size();
        this.dashboards.visible(dashboardCount > 0 && this.page == AppTemplate.Page.Dashboards);
        this.dashboardsLink.visible(dashboardCount > 0 && this.page != AppTemplate.Page.Dashboards);
        this.cubes.visible(cubeCount > 0 && this.page == AppTemplate.Page.Cube);
        this.cubesLink.visible(cubeCount > 0 && this.page != AppTemplate.Page.Cube);
    }

    private void initLogo() {
        URL logo = ((SumusBox)this.box()).logoUrl();
        if (logo != null) {
            this.logo.value(logo, "image/png", "logo.png");
        }
    }

    private void initTitle() {
        Theme theme = ((SumusBox)this.box()).theme();
        this.appTitle.visible(theme.containsKey("title"));
        if (this.appTitle.isVisible()) {
            this.appTitle.value((String)theme.get("title"));
        }
        this.appDescription.visible(((SumusBox)this.box()).theme().containsKey("description"));
        if (this.appDescription.isVisible()) {
            this.appDescription.value((String)theme.get("description"));
        }
    }
}

