import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDateEditable from "alexandria-ui-elements/src/displays/components/DateEditable";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import DisplaysReportTemplate from "sumus-elements/gen/displays/templates/ReportTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DashboardTemplateNotifier from "sumus-elements/gen/displays/notifiers/DashboardTemplateNotifier";
import DashboardTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DashboardTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DashboardTemplateNotifier(this);
		this.requester = new DashboardTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="horizontal flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a592123310" format="blueRightBordered doubleAirRight doubleRightSpaced columnMinWidth" layout="vertical" width="calc(20% - 20px)" height="100.0%">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a592123310.a516918281" format="topSpaced doubleLeftSpaced bottomSpaced" visible={false} mode="normal" translate={true} value="No reports found">
					</UiText>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a592123310.a1144681644" format="bottomSpaced doubleLeftSpaced" layout="horizontal center">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a592123310.a1144681644.a1304751639" format="doubleAirRight" layout="vertical flexible">
							<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a592123310.a1144681644.a1304751639.a1016484928" pattern="DD/MM/YYYY" mode="tonow">
							</UiDateEditable>
						</UiBlock>
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a592123310.a1144681644.a2026394507" title="Previous period" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Small" format="mediumIconSize middleAirRight">
						</UiAction>
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a592123310.a1144681644.a1298475015" title="Next period" target="self" mode="MaterialIconButton" icon="ChevronRight" size="Small" format="mediumIconSize">
						</UiAction>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a592123310.a704754152" layout="horizontal center">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a592123310.a704754152.a217969602" format="bottomSpaced doubleLeftSpaced" visible={false} layout="vertical flexible">
							<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a592123310.a704754152.a217969602.a_1614839412" multipleSelection={false} maxMenuHeight={300}>
							</UiSelectorComboBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a592123310.a704754152.a_1775608672" format="bottomSpaced doubleLeftSpaced" visible={false} layout="vertical flexible">
							<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a592123310.a704754152.a_1775608672.a1005748590" multipleSelection={false} maxMenuHeight={300}>
							</UiSelectorComboBox>
						</UiBlock>
					</UiBlock>
					<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a592123310.a_1878321197" format="doubleLeftSpaced" multipleSelection={false}>
					</UiSelectorListBox>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1616384791" format="middleAirTop doubleAirBottom" layout="horizontal flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1616384791.a_1773601783" format="overflowAuto" layout="vertical flexible" width="100px" height="-1px">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1616384791.a_1773601783.a230712662" layout="vertical flexible">
							<DisplaysReportTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1616384791.a_1773601783.a230712662.a182849926">
							</DisplaysReportTemplate>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
	    if (!this.props.onProxyMessage) return;
	    this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(DashboardTemplate));
DisplayFactory.register("DashboardTemplate", withStyles(styles, { withTheme: true })(withSnackbar(DashboardTemplate)));