import Requester from "./Requester";

export default class CubeBarChartRequester extends Requester {
	constructor(element) {
		super(element);
	};
	sort = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ app: this.element.context, op: "sort", s: "cubebarchart", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	selectIndicator = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ app: this.element.context, op: "selectIndicator", s: "cubebarchart", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	selectDrillCategory = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ app: this.element.context, op: "selectDrillCategory", s: "cubebarchart", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	selectDivideByCategory = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ app: this.element.context, op: "selectDivideByCategory", s: "cubebarchart", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "cubebarchart", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}