/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.resources;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.DisplayRepository;
import io.intino.alexandria.ui.displays.DisplayRouter;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.spark.UISparkManager;
import io.intino.alexandria.ui.spark.resources.Resource;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.displays.RouteDispatcher;
import io.intino.sumus.box.ui.pages.DashboardPage;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class DashboardResource
extends Resource {
    private final SumusBox box;

    public DashboardResource(SumusBox box, UISparkManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
        this.box = box;
    }

    public void execute() throws AlexandriaException {
        super.execute();
        this.fillDeviceParameter();
        if (this.isLogged()) {
            this.render();
        } else {
            this.authenticate();
        }
    }

    private void render() {
        String clientId = UUID.randomUUID().toString();
        final DashboardPage page = new DashboardPage();
        page.session = this.manager.currentSession();
        page.session.browser().onRedirect(location -> this.manager.redirect(location));
        page.session.browser().requestUrl(this.manager.requestUrl());
        page.session.whenLogin((Function)new Function<String, String>(){

            @Override
            public String apply(String baseUrl) {
                return DashboardResource.this.authenticate(page.session, baseUrl);
            }
        });
        page.session.whenLogout(b -> this.logout(page.session));
        page.box = this.box;
        page.clientId = clientId;
        page.device = this.parameterValue("device");
        page.token = this.parameterValue("token");
        page.dashboard = this.parameterValue("dashboard");
        if (!page.hasPermissions()) {
            this.manager.redirect(page.redirectUrl());
            return;
        }
        ((PushService)this.manager.pushService()).onOpen(client -> {
            if (!client.id().equals(page.clientId)) {
                return false;
            }
            if (client.soul() != null) {
                ((RouteDispatcher)this.box.routeManager().routeDispatcher()).dispatchDashboard(client.soul(), page.dashboard);
                return false;
            }
            Soul soul = page.prepareSoul((UIClient)client);
            soul.onRedirect(location -> this.manager.redirect(location));
            soul.addRegisterDisplayListener(display -> {
                display.inject(this.notifier(page.session, (UIClient)client, (Display)display));
                display.inject(page.session);
                display.inject((DisplayRepository)soul);
                display.inject(() -> soul);
            });
            client.soul(soul);
            client.cookies(this.manager.cookies());
            this.box.registerSoul(clientId, soul);
            soul.register(new DisplayRouter((AlexandriaUiBox)this.box).id("__router__"));
            ((RouteDispatcher)this.box.routeManager().routeDispatcher()).dispatchDashboard(soul, page.dashboard);
            return true;
        });
        ((PushService)this.manager.pushService()).onClose(clientId).execute((Consumer)new Consumer<UIClient>(){

            @Override
            public void accept(UIClient client) {
                DashboardResource.this.box.soul(client.id()).ifPresent(s -> s.destroy());
                DashboardResource.this.box.unRegisterSoul(client.id());
                DashboardResource.this.manager.unRegister(client);
            }
        });
        this.manager.write((Object)page.execute());
    }
}

