/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays.templates;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.components.DynamicTable;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.filters.GroupFilter;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.datasources.CubeDatasource;
import io.intino.sumus.box.ui.datasources.MicroSiteBuilderOfCube;
import io.intino.sumus.box.ui.displays.CubeBarChart;
import io.intino.sumus.box.ui.displays.DisplayHelper;
import io.intino.sumus.box.ui.displays.rows.CubeTableRow;
import io.intino.sumus.box.ui.displays.templates.AbstractCubeViewer;
import io.intino.sumus.box.ui.displays.templates.CubeDialog;
import io.intino.sumus.engine.Fact;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CubeViewer
extends AbstractCubeViewer<SumusBox> {
    private CubeDatasource source;
    private CubeDialog dialog;
    private String selectedDrill;
    private String selectedDivideBy;
    private Map<String, List<String>> filters = new HashMap<String, List<String>>();

    public CubeViewer(Box box) {
        super((SumusBox)box);
    }

    public <A extends CubeDatasource> A source() {
        return (A)((Object)this.source);
    }

    public CubeViewer source(CubeDatasource source) {
        this.source = source;
        if (this.cubeDynamicTableBlock.isVisible()) {
            this.cubeDynamicTableBlock.cubeTable.source((Datasource)source);
        }
        return this;
    }

    public CubeViewer dialog(CubeDialog dialog) {
        this.dialog = dialog;
        dialog.onSelectDrill(this::selectDrill);
        dialog.onSelectZoomLevel(this::selectZoomLevel);
        dialog.onSelectDivideBy(this::selectDivideBy);
        dialog.onTranspose(this::transpose);
        dialog.onResetFilters(this::resetFilters);
        dialog.onApplyFilters(this::applyFilters);
        dialog.onAttachDimension(e -> this.reload(false));
        dialog.onSelectView(this::showView);
        return this;
    }

    public void updateTimetag(Timetag timetag) {
        this.source.timetag(timetag);
        if (this.cubeDynamicTableBlock.cubeTable != null) {
            this.filterTimetag();
        }
        if (this.barChartBlock.isVisible()) {
            CubeBarChart chart = this.barChart();
            chart.timetag(timetag);
            chart.refresh();
        }
    }

    private void showView(CubeDialog.View view) {
        if (view == CubeDialog.View.ListView || view == CubeDialog.View.TableView) {
            this.cubeDynamicTableBlock.show();
            this.barChartBlock.hide();
            if (view == CubeDialog.View.ListView) {
                this.cubeDynamicTableBlock.cubeTable.openView(DynamicTable.View.Normal);
            } else {
                this.cubeDynamicTableBlock.cubeTable.openView(DynamicTable.View.Indicator);
            }
        } else {
            this.cubeDynamicTableBlock.hide();
            this.barChartBlock.show();
        }
    }

    private void hideViews() {
        this.cubeDynamicTableBlock.hide();
        this.barChartBlock.hide();
    }

    @Override
    public void init() {
        super.init();
        this.initBarChart();
        this.initTable();
    }

    public void refresh() {
        super.refresh();
        if (this.cubeDynamicTableBlock.isVisible()) {
            this.cubeDynamicTableBlock.show();
        }
    }

    private void initTable() {
        this.cubeDynamicTableBlock.onInit(e -> {
            this.cubeDynamicTableBlock.cubeTable.onAddItem(e1 -> {
                Fact fact = (Fact)e1.item();
                CubeTableRow row = (CubeTableRow)e1.component();
            });
            this.cubeDynamicTableBlock.cubeTable.onOpeningRow(e1 -> this.notifyUser(this.translate("Generating report. This operation may take time. Please wait..."), UserMessage.Type.Loading));
            this.cubeDynamicTableBlock.cubeTable.onOpenRow(e1 -> {
                Timetag timetag = new Timetag(Instant.now(), Scale.Day);
                MicroSiteBuilderOfCube builder = new MicroSiteBuilderOfCube((SumusBox)this.box(), DisplayHelper.cellProvider((SumusBox)this.box(), this.source), this.language());
                Iterator<Fact> details = this.source.details(this.source.timetag(), e1.section(), e1.row(), this.cubeDynamicTableBlock.cubeTable.filters());
                String result = builder.build(timetag, this.source.title(), this.source.description(e1.section().label(), e1.row()), this.source.itemColumns(), details);
                this.notifyUser(this.translate("Report generated"), UserMessage.Type.Success);
                String url = ((SumusBox)this.box()).configuration().url();
                return url + (url.endsWith("/") ? "" : "/") + "drills/" + timetag + "/" + result + "/";
            });
            this.cubeDynamicTableBlock.cubeTable.onSelectRows(e1 -> this.dialog.suggestedFilters(e1.selection()));
            this.cubeDynamicTableBlock.cubeTable.translator(word -> this.source.translate((String)word));
        });
        this.cubeDynamicTableBlock.onShow(e -> {
            if (this.cubeDynamicTableBlock.cubeTable.source() == null) {
                this.cubeDynamicTableBlock.cubeTable.source((Datasource)this.source);
            } else {
                this.cubeDynamicTableBlock.cubeTable.filter(this.filters);
            }
            if (this.dialog != null) {
                this.refreshTable();
            }
        });
    }

    private void initBarChart() {
        this.barChartBlock.onShow(e -> {
            this.barChartBlock.cubeBarChart.clear();
            this.barChartBlock.cubeBarChart.display((Display)new CubeBarChart((SumusBox)this.box()));
            this.barChart().source(this.source);
            this.barChart().timetag(this.source.timetag());
            this.barChart().divideBy(this.source.dimension());
            this.barChart().drill(this.source.drill());
            this.barChart().refresh();
        });
    }

    private void refreshTable() {
        if (this.cubeDynamicTableBlock.cubeTable.source() == null) {
            this.cubeDynamicTableBlock.cubeTable.source((Datasource)this.source);
        }
        this.cubeDynamicTableBlock.cubeTable.dimension(this.source.dimension());
        this.cubeDynamicTableBlock.cubeTable.drill(this.source.drill());
        this.cubeDynamicTableBlock.cubeTable.filter(this.source.timetag());
    }

    private void filterTimetag() {
        this.cubeDynamicTableBlock.cubeTable.drill(this.source.drill());
        this.cubeDynamicTableBlock.cubeTable.dimension(this.source.dimension());
        this.cubeDynamicTableBlock.cubeTable.filter(this.source.timetag());
    }

    private void showLoading() {
        if (this.barChartBlock.isVisible()) {
            this.barChart().showLoading();
        }
    }

    private void selectDrill(String drill, Boolean swapping) {
        if (drill != null && drill.equals(this.selectedDrill)) {
            return;
        }
        if (this.cubeDynamicTableBlock.cubeTable != null) {
            this.cubeDynamicTableBlock.cubeTable.drill(drill);
        }
        if (this.barChartBlock.isVisible()) {
            this.barChart().drill(drill);
        }
        this.reload(swapping);
        this.selectedDrill = drill;
    }

    private void selectZoomLevel(int level) {
        this.reload(false);
    }

    private void transpose(Boolean value) {
        this.reload();
    }

    private void selectDivideBy(String divideBy, Boolean swapping) {
        if (divideBy != null && divideBy.equals(this.selectedDivideBy)) {
            return;
        }
        if (this.cubeDynamicTableBlock.cubeTable != null) {
            this.cubeDynamicTableBlock.cubeTable.dimension(divideBy);
        }
        if (this.barChartBlock.isVisible()) {
            this.barChart().divideBy(divideBy);
        }
        this.reload(swapping);
        this.selectedDivideBy = divideBy;
    }

    private void reload(boolean swapping) {
        if (swapping) {
            return;
        }
        this.reload();
    }

    private void reload() {
        if (this.cubeDynamicTableBlock.isVisible()) {
            this.cubeDynamicTableBlock.cubeTable.reload();
        }
        if (this.barChartBlock.isVisible()) {
            this.barChart().refresh();
        }
    }

    private CubeBarChart barChart() {
        return (CubeBarChart)this.barChartBlock.cubeBarChart.display();
    }

    public void applyFilters(Map<String, List<String>> filters) {
        this.filters.putAll(filters);
        this.dialog.updateFiltersMessage(this.filters);
        if (this.cubeDynamicTableBlock.isVisible()) {
            this.cubeDynamicTableBlock.cubeTable.filter(this.filters);
        }
        if (this.barChartBlock.isVisible()) {
            this.source.filters(this.toFilters(filters));
            this.barChart().refresh();
        }
    }

    private List<Filter> toFilters(Map<String, List<String>> filters) {
        return filters.entrySet().stream().map(e -> new GroupFilter((String)e.getKey(), (List)e.getValue())).collect(Collectors.toList());
    }

    private void resetFilters(Boolean value) {
        this.filters.clear();
        this.dialog.updateFiltersMessage(this.filters);
        if (this.cubeDynamicTableBlock.cubeTable != null) {
            this.cubeDynamicTableBlock.cubeTable.filter(this.filters);
        }
        if (this.barChartBlock.isVisible()) {
            this.barChart().refresh();
        }
    }
}

