/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays;

import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractRouteDispatcher
implements DisplayRouteDispatcher {
    private static Map<String, String> patterns = new HashMap<String, String>();

    public AbstractRouteDispatcher() {
        this.registerPatterns();
    }

    public void dispatch(Soul soul, String address) {
        address = address.replaceFirst(soul.session().browser().basePath(), "");
        List<String> params = this.paramsOf(address);
        if (address.length() <= 1) {
            this.dispatchHome(soul);
            return;
        }
        if (address.matches(patterns.get("home"))) {
            this.dispatchHome(soul);
            return;
        }
        if (address.matches(patterns.get("dashboards"))) {
            this.dispatchDashboards(soul);
            return;
        }
        if (address.matches(patterns.get("dashboard"))) {
            this.dispatchDashboard(soul, params.get(0));
            return;
        }
        if (address.matches(patterns.get("report"))) {
            this.dispatchReport(soul, params.get(0), params.get(1), params.get(2), params.get(3));
            return;
        }
        if (address.matches(patterns.get("cubes"))) {
            this.dispatchCubes(soul);
            return;
        }
        if (address.matches(patterns.get("cube"))) {
            this.dispatchCube(soul, params.get(0));
            return;
        }
        if (address.matches(patterns.get("cubeQuery"))) {
            this.dispatchCubeQuery(soul, params.get(0), params.get(1), params.get(2), params.get(3));
            return;
        }
        if (address.matches(patterns.get("sitesIndex"))) {
            this.dispatchSitesIndex(soul, params.get(0), params.get(1));
            return;
        }
        if (address.matches(patterns.get("sites"))) {
            this.dispatchSites(soul, params.get(0), params.get(1), params.get(2));
            return;
        }
    }

    public abstract void dispatchHome(Soul var1);

    public abstract void dispatchDashboards(Soul var1);

    public abstract void dispatchDashboard(Soul var1, String var2);

    public abstract void dispatchReport(Soul var1, String var2, String var3, String var4, String var5);

    public abstract void dispatchCubes(Soul var1);

    public abstract void dispatchCube(Soul var1, String var2);

    public abstract void dispatchCubeQuery(Soul var1, String var2, String var3, String var4, String var5);

    public abstract void dispatchSitesIndex(Soul var1, String var2, String var3);

    public abstract void dispatchSites(Soul var1, String var2, String var3, String var4);

    private void registerPatterns() {
        if (patterns.size() > 0) {
            return;
        }
        patterns.put("home", "");
        patterns.put("dashboards", "\\/dashboards");
        patterns.put("dashboard", "\\/dashboard\\/([^\\/]*)");
        patterns.put("report", "\\/dashboard\\/([^\\/]*)\\/([^\\/]*)\\/([^\\/]*)\\/([^\\/]*)");
        patterns.put("cubes", "\\/olap");
        patterns.put("cube", "\\/olap\\/([^\\/]*)");
        patterns.put("cubeQuery", "\\/olap\\/([^\\/]*)\\/([^\\/]*)\\/([^\\/]*)\\/([^\\/]*)");
        patterns.put("sitesIndex", "\\/drills\\/([^\\/]*)\\/([^\\/]*)");
        patterns.put("sites", "\\/drills\\/([^\\/]*)\\/([^\\/]*)\\/([^\\/]*)");
    }

    private String patternOf(String address) {
        if (address.matches(patterns.get("home"))) {
            return patterns.get("home");
        }
        if (address.matches(patterns.get("home"))) {
            return patterns.get("home");
        }
        if (address.matches(patterns.get("dashboards"))) {
            return patterns.get("dashboards");
        }
        if (address.matches(patterns.get("dashboard"))) {
            return patterns.get("dashboard");
        }
        if (address.matches(patterns.get("report"))) {
            return patterns.get("report");
        }
        if (address.matches(patterns.get("cubes"))) {
            return patterns.get("cubes");
        }
        if (address.matches(patterns.get("cube"))) {
            return patterns.get("cube");
        }
        if (address.matches(patterns.get("cubeQuery"))) {
            return patterns.get("cubeQuery");
        }
        if (address.matches(patterns.get("sitesIndex"))) {
            return patterns.get("sitesIndex");
        }
        if (address.matches(patterns.get("sites"))) {
            return patterns.get("sites");
        }
        return null;
    }

    private List<String> paramsOf(String address) {
        return this.paramsOf(address, this.patternOf(address));
    }

    private List<String> paramsOf(String address, String pattern) {
        if (pattern == null) {
            return Collections.emptyList();
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(address);
        if (!m.find()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i <= m.groupCount(); ++i) {
            result.add(m.group(i));
        }
        return result;
    }
}

